% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cumulative_hazard_to_survival}
\alias{cumulative_hazard_to_survival}
\title{Transform Cumulative Hazard to Survival}
\usage{
cumulative_hazard_to_survival(hazard_functions)
}
\arguments{
\item{hazard_functions}{matrix or vector, with each row representing a cumulative hazard function}
}
\value{
A matrix or vector transformed to the form of a survival function.
}
\description{
Helper function to transform between CHF and survival function
}
\examples{
library(survex)

vec <- c(1, 2, 3, 4, 5)
matr <- matrix(c(1, 2, 3, 2, 4, 6), ncol = 3)

cumulative_hazard_to_survival(vec)

cumulative_hazard_to_survival(matr)

}
