% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.R
\name{model_performance}
\alias{model_performance}
\alias{model_performance.surv_explainer}
\title{Dataset Level Performance Measures}
\usage{
model_performance(explainer, ...)

\method{model_performance}{surv_explainer}(explainer, ..., type = "metrics", times = NULL)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{explain()} function}

\item{...}{other parameters, currently ignored}

\item{type}{character, either \code{"metrics"} or \code{"roc"}. If \code{"metrics"} then performance metrics are calculated, if \code{"roc"} ROC curves for selected time points are calculated.}

\item{times}{a numeric vector of times. If \code{type == "metrics"} then the survival function is evaluated at these times, if \code{type == "roc"} then the ROC curves are calculated at these times.}
}
\value{
An object of class \code{"model_performance_survival"}. It's a list of metric values calculated for the model.
}
\description{
This function calculates metrics for survival models. The metrics calculated are C/D AUC, Brier score, and their integrated versions, as well as concordance index. It also can calculate ROC curves for specific selected time points.
}
\examples{
library(survival)
library(survex)


cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
rsf_ranger <- ranger::ranger(Surv(time, status) ~ .,
                            data = veteran,
                            respect.unordered.factors = TRUE,
                            num.trees = 100,
                            mtry = 3,
                            max.depth = 5)

rsf_src <- randomForestSRC::rfsrc(Surv(time, status) ~ .,
                                data = veteran)

cph_exp <- explain(cph)
rsf_ranger_exp <- explain(rsf_ranger, data = veteran[, -c(3, 4)],
                          y = Surv(veteran$time, veteran$status))
rsf_src_exp <- explain(rsf_src)


cph_model_performance <- model_performance(cph_exp)
rsf_ranger_model_performance <- model_performance(rsf_ranger_exp)
rsf_src_model_performance <- model_performance(rsf_src_exp)

print(cph_model_performance)

plot(rsf_ranger_model_performance, cph_model_performance,
     rsf_src_model_performance, metrics_type = "scalar")

plot(rsf_ranger_model_performance, cph_model_performance, rsf_src_model_performance)

cph_model_performance_roc <- model_performance(cph_exp, type = "roc", times = c(100, 500, 1200))
plot(cph_model_performance_roc)

}
