% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_SRF.R
\name{survsrf_tune}
\alias{survsrf_tune}
\title{Internal function to tune SRF model, in nested CV loop}
\usage{
survsrf_tune(
  df_tune,
  predict.factors,
  inner_cv = 3,
  fixed_time = NaN,
  randomseed = NULL,
  mtry = c(3, 4, 5),
  nodesize = c(10, 20, 50),
  nodedepth = c(100),
  verbose = FALSE,
  oob = TRUE
)
}
\arguments{
\item{df_tune}{data frame}

\item{predict.factors}{predictor names}

\item{inner_cv}{k in k-fold CV, applied if oob=FALSE}

\item{fixed_time}{NaN}

\item{randomseed}{random seed}

\item{mtry}{tuning parameter}

\item{nodesize}{at which event probabilities are computed}

\item{nodedepth}{tuning parameter}

\item{verbose}{FALSE}

\item{oob}{TRUE/FALSE use out-of-bag predictions while tuning instead of cross-validation, default is TRUE and is faster}
}
\value{
output=list(modelstats, bestbrier, bestauc, bestcindex)
}
\description{
Internal function to tune SRF model, in nested CV loop
}
