% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_km_pi.R
\name{calc_km_pi}
\alias{calc_km_pi}
\title{Generate Kaplan-Meier curves with prediction intervals from parametric bootstrap simulation}
\usage{
calc_km_pi(
  sim,
  trt = NULL,
  group = NULL,
  pi.range = 0.95,
  calc.obs = TRUE,
  simtimelast = NULL,
  trt.assign = c("default", "reverse")
)
}
\arguments{
\item{sim}{A \code{survparamsim} class object generated by \code{\link[=surv_param_sim]{surv_param_sim()}} function.}

\item{trt}{An optional string to specify which column define treatment status.
You will have survival curves with different colors in \code{\link[=plot_km_pi]{plot_km_pi()}} function.}

\item{group}{Optional string(s) to specify grouping variable(s).
You will have faceted survival curves for these variables in \code{\link[=plot_km_pi]{plot_km_pi()}} function.}

\item{pi.range}{Prediction interval for simulated survival curves.}

\item{calc.obs}{A logical to specify whether KM estimates will be performed
for the observed data. Need be set as FALSE if survival information in the \code{newdata} is dummy.}

\item{simtimelast}{An optional numeric to specify last simulation time for survival curve.
If NULL (default), the last observation time in the \code{newdata} will be used.}

\item{trt.assign}{Specify which of the categories of \code{trt} need to be considered as control group.
See details below if you have more than two categories. Only applicable if you will use
\code{\link[=extract_medsurv_delta_pi]{extract_medsurv_delta_pi()}} to extract delta of median survival times.}
}
\description{
Generate Kaplan-Meier curves with prediction intervals from parametric bootstrap simulation
}
\details{
If your \code{trt} has more than two categories/levels and want to specify which one to use as a
reference group, you can convert the column into a factor in the \code{newdata} input for
\code{\link[=surv_param_sim]{surv_param_sim()}}. The first level will be used as a reference group.
}
