% Generated by roxygen2 (4.0.1): do not edit by hand
\name{autoplot.survfit}
\alias{autoplot.survfit}
\title{Generate a \code{ggplot} for a \code{survfit} object}
\usage{
\method{autoplot}{survfit}(object, ..., xLab = "Time", yLab = "Survival",
  title = "Marks show times with censoring", titleSize = 15,
  axisTitleSize = 15, axisLabSize = 10, survLineSize = 0.5,
  type = c("single", "CI", "fill"), palette = c("Dark2", "Set2", "Accent",
  "Paired", "Pastel1", "Pastel2", "Set1", "Set3"), jitter = c("none",
  "noEvents", "all"), censShape = 3, censSize = 5, legend = TRUE,
  legLabs = NULL, legTitle = "Strata", legTitleSize = 10,
  legLabSize = 10, alpha = 0.05, CIline = 10, fillLineSize = 0.05,
  pVal = FALSE, sigP = 1, pX = 0.1, pY = 0.1, timeTicks = c("major",
  "minor"), tabTitle = "Number at risk by time", tabTitleSize = 15,
  tabLabSize = 5, nRiskSize = 5)
}
\arguments{
\item{object}{An object of class \code{survfit}.}

\item{...}{Additional arguments (not implemented).}

\item{xLab}{Label for \eqn{x} axis on survival plot.}

\item{yLab}{Label for \eqn{y} axis on survival plot.}

\item{title}{Title for survival plot.}

\item{titleSize}{Title size for survival plot.}

\item{axisTitleSize}{Title size for axes.}

\item{axisLabSize}{Title size for label axes.}

\item{survLineSize}{Survival line size.}

\item{type}{Type of plot. The default, \code{type="single"}, plots single lines.
 \itemize{
 \item If \code{type="CI"} will add lines indicating
       confidence intervals (taken from \code{upper} and \code{lower}
       values of \code{survfit} object).
       \cr
       Higher values of \code{alpha} (transparency) are recommended for this,
       e.g. \code{alpha=0.8}.
 \item If \code{type="fill"} will add filled rectangles from the survival lines to
       the confidence intervals above.
}}

\item{palette}{Options are taken from
\href{http://colorbrewer2.org/}{color_brewer}.
  \itemize{
    \item \code{palette="Dark2"} (the default) is recommended for
          \code{single} or \code{CI} plots.
    \item \code{palette="Set2"} is recommended for \code{fill} plots.
}}

\item{jitter}{By default, \code{jitter="none"}.
\itemize{
 \item If \code{jitter="noEvents"}, adds some random, positive noise
to survival lines with no events (i.e. all observations censored).
This will bring them just above 1 on the y-axis, making them easier to see separately.
  \item If \code{jitter="all"} add some vertical noise to all survival lines.
}}

\item{legend}{If \code{legend=FALSE}, no legends will be produced
for the plot or table.}

\item{legLabs}{These can be used to replace the names
of the strata from the fit.
\cr
Should be given in the same order as those strata.}

\item{legTitle}{Title for legend.}

\item{legTitleSize}{Title size for legend.}

\item{legLabSize}{Legend labels width and height.}

\item{alpha}{Alpha, the transparency of lines indicating confidence intervals
or filled rectangles. Should be in the range \eqn{0} to \eqn{1}.
\cr
Larger values e.g. \code{alpha=0.7} are recommended for confidence
intervals.}

\item{censShape}{Shape of marks to indicate censored onservations.
\cr
Default is \code{3} which gives vertical ticks.
\cr
Use \code{censShape=10} for circular marks.}

\item{censSize}{Size of marks to indicate censored onservations.}

\item{CIline}{Confidence interval line type.}

\item{fillLineSize}{Line size surrouding filled boxes.}

\item{pVal}{If \code{pVal=TRUE}, adds \eqn{p} value from
log-rank test to plot}

\item{sigP}{No. of significant digits to display in \eqn{p} value.
Typically \eqn{1} to \eqn{3}.}

\item{pX}{Location of \eqn{p} value on \eqn{x} axis.
\cr
Should be in the range of \eqn{0} to \eqn{1}.
The location is relative to the maximum observed time.
\cr
E.g. \code{pX = 0.5} will place it half-way along the \eqn{x}-axis.}

\item{pY}{Location of \eqn{p} value on \eqn{y} axis.
\cr
Should be in the range of \eqn{0 - 1}, as above}

\item{timeTicks}{Numbers to mark on the survival plot and table.
\itemize{
  \item If \code{timeTicks="major"} (the default)
        only the major \eqn{x}-axis (time) marks from the
        survival plot are are labelled on the plot and table.
  \item If \code{timeTicks="minor"}, minor axis marks are labelled instead.
}}

\item{tabTitle}{Table title.}

\item{tabTitleSize}{Table title text size.}

\item{tabLabSize}{Table legend text size.}

\item{nRiskSize}{Number at risk - text size.}
}
\value{
A \code{list} of \code{ggplot} objects, with elements:
\item{plot}{the survial plot}
\item{table}{the table of events per time}
This \code{list} has the additional \code{class} of
\code{tableAndPlot}, allowing methods from \code{\link{autoplot.tableAndPlot}}.
}
\description{
Uses \code{ggplot2} to render a table showing the number of subjects
at risk per time period and survival curves (Kaplan-Meier plot) and to render
}
\note{
\itemize{
  \item The returned \code{list} contains standard \code{ggplot2} objects.
        \cr
        These can be modified further, as in the last example, which changes
        to colors to a user-defined sequence.
        \cr
        The default color scheme has been chosen for ease of display and accessibility.
  \item Size arguments are passed to \code{ggplot2}'s \code{x=element_text(size=)}.
}
}
\examples{
data(kidney, package="KMsurv")
s1 <- survfit(Surv(time, delta) ~ type, data=kidney)
autoplot(s1, type="fill", survLineSize=2)
autoplot(s1, type="CI", pVal=TRUE, pX=0.3,
 legLabs=c("surgical", "percutaneous"),
 title="Time to infection following catheter placement \\n
   by type of catheter, for dialysis patients")$plot
s1 <- survfit(Surv(time=time, event=delta) ~ 1, data=kidney)
autoplot(s1, legLabs="")$plot
autoplot(s1, legend=FALSE)$plot
### load all datasets from package:km.ci
d1 <- data(package="km.ci")$results[, "Item"]
data(list=d1, package="km.ci")
s1 <- survfit(Surv(time, status) ~ 1, data=rectum.dat)
### change confidence intervals to log Equal-Precision confidence bands
km.ci::km.ci(s1, method="logep")
autoplot(s1, type="fill", legend=FALSE)$plot
###
### change to user-defined colors
###
s1 <- survfit(Surv(time, delta) ~ type, data=kidney)
g1 <- autoplot(s1, type="CI", alpha=0.8, survLineSize=2)$plot
g1 + scale_colour_manual(values=c("red", "blue")) +
    scale_fill_manual(values=c("red", "blue"))
}
\author{
Chris Dardis. Based on existing work by
R. Saccilotto, Abhijit Dasgupta, Gil Tomas and Mark Cowley.
}
\keyword{plot}
\keyword{survival}

