% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supernova.R
\name{supernova}
\alias{supernova}
\alias{superanova}
\alias{supernova.lm}
\alias{supernova.lmerMod}
\title{supernova}
\usage{
supernova(fit, type = 3, verbose = TRUE)

superanova(fit, type = 3, verbose = TRUE)

\method{supernova}{lm}(fit, type = 3, verbose = TRUE)

\method{supernova}{lmerMod}(fit, type = 3, verbose = FALSE)
}
\arguments{
\item{fit}{A model fit by \code{\link[=lm]{lm()}} or \code{\link[lme4:lmer]{lme4::lmer()}}}

\item{type}{The type of sums of squares to calculate (see \code{\link[=generate_models]{generate_models()}}). Defaults to the
widely used Type \code{III} SS.}

\item{verbose}{If \code{FALSE}, the \code{description} column is suppressed.}
}
\value{
An object of the class \code{supernova}, which has a clean print method for displaying the
ANOVA table in the console as well as a named list:
\item{tbl}{The ANOVA table as a \code{\link{data.frame}}}
\item{fit}{The original \code{\link[stats]{lm}} or \code{\link[lme4]{lmer}}
object being tested}
\item{models}{Models created by \code{\link{generate_models}}}
}
\description{
An alternative set of summary statistics for ANOVA. Sums of squares, degrees
of freedom, mean squares, and F value are all computed with Type III sums of
squares, but for fully-between subjects designs you can set the type to I or
II. This function adds to the output table the proportional reduction in
error, an explicit summary of the whole model, separate formatting of p
values, and is intended to match the output used in Judd, McClelland, and
Ryan (2017).
}
\details{
\code{superanova()} is an alias of \code{supernova()}
}
\examples{
supernova(lm(mpg ~ disp, data = mtcars))
supernova(lm(mpg ~ disp, data = mtcars)) \%>\% print(pcut = 8)
}
\references{
Judd, C. M., McClelland, G. H., & Ryan, C. S. (2017). \emph{Data
Analysis: A Model Comparison Approach to Regression, ANOVA, and Beyond}
(3rd ed.). New York: Routledge. ISBN:879-1138819832
}
