% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superbPlot.R
\name{superbPlot}
\alias{superbPlot}
\title{superbPlot}
\usage{
superbPlot(
  data,
  BSFactor = NULL,
  WSFactor = NULL,
  factorOrder,
  variables,
  statistic = "mean",
  errorbar = "CI",
  gamma = 0.95,
  adjustments = list(purpose = "single", popSize = Inf, decorrelation = "none",
    samplingDesign = "SRS"),
  showPlot = TRUE,
  plotStyle = "bar",
  Debug = FALSE,
  Quiet = FALSE,
  preprocessfct = NULL,
  postprocessfct = NULL,
  clusterColumn = "",
  ...
)
}
\arguments{
\item{data}{Dataframe in wide format}

\item{BSFactor}{The name of the columns containing the between-subject factor(s)}

\item{WSFactor}{The name of the within-subject factor(s)}

\item{factorOrder}{Order of factors as shown in the graph (x axis, groups, horizontal 
panels, vertical panels)}

\item{variables}{The dependent variable(s)}

\item{statistic}{The summary statistic function to use}

\item{errorbar}{The function that computes the error bar. Should be "CI" or "SE" or 
any function name. Defaults to "SE"}

\item{gamma}{The coverage factor; necessary when errorbar == "CI". Default is 0.95.}

\item{adjustments}{List of adjustments as described below:
 popsize: Size of the population under study. Defaults to Inf
 purpose: The purpose of the comparisons. Defaults to "single". 
     Can be "single" or "difference".
decorrelation: Decorrelation method for repeated measure designs. 
     Chooses among the methods ("CM", "LM", "CA" or "none"). Defaults to "none".
samplingDesign: Sampling method to obtain the sample. implemented 
         sampling is "SRS" (Simple Randomize Sampling) and "CRS" (Cluster-Randomized Sampling).
Default is adjustments = list(purpose = "single", popSize = Inf, decorrelation = "none",
             samplingDesign = "SRS")}

\item{showPlot}{Defaults to TRUE. Set to FALSE if you want the output to be the summary statistics and intervals.}

\item{plotStyle}{The type of object to plot on the graph. Can be either "bar" or "line".
Defaults to "bar".}

\item{Debug}{export internal information into global environment. Default is FALSE}

\item{Quiet}{Default to False, a boolean to inhibit showing additional information as warnings}

\item{preprocessfct}{is a transform (or vector of) to be performed first on data matrix of each group}

\item{postprocessfct}{is a transform (or vector of)}

\item{clusterColumn}{used in conjunction with samplingDesign = "CRS", indicates which column contains the cluster membership}

\item{...}{In addition to the parameters above, superbPlot also accept a number of 
optional arguments that will be transmitted to the plotting function, such as
pointParams (a list of ggplot2 parameters to input inside geoms; see ?geom_bar2) and
errorbarParams (a list of ggplot2 parameters for geom_errorbar; see ?geom_errorbar)}
}
\value{
a plot with the correct error bars or a table of those summary statistics.
        The plot is a ggplot2 object with can be modified with additional declarations.
}
\description{
plotsuberb plots standard error or confidence interval for various descriptive 
     statistics under various designs, sampling schemes, population size and purposes,
     according to the suberb framework. See \insertCite{c17}{superb} for more.
}
\examples{
# basic example using a built-in dataframe as data; 
# by default, the mean is computed and the error bar are 95\% confidence intervals
superbPlot(ToothGrowth, BSFactor = c("dose", "supp"), 
  variables = "len") 

# example changing the summary statistics to the median and
# the error bar to 90\% confidence intervals
superbPlot(ToothGrowth, BSFactor = c("dose", "supp"), 
  variables = "len", statistic = "median", errorbar = "CI", gamma = .90) 

# example introducing adjustments for pairwise comparisons 
# and assuming that the whole population is limited to 200 persons
superbPlot(ToothGrowth, BSFactor = c("dose", "supp"), 
  variables = "len",  
  adjustments = list( purpose = "difference", popSize = 200) )

# This example add ggplot directives to the plot produced
library(ggplot2)
superbPlot(ToothGrowth, BSFactor = c("dose", "supp"), 
  variables = "len") + 
  xlab("Dose") + ylab("Tooth Growth") +
  theme_bw()

# This example is based on repeated measures
library(lsr)
library(gridExtra)
# define shorter column names...
names(Orange) <- c("Tree","age","circ")
# turn the data into a wide format
Orange.wide <- longToWide(Orange, circ ~ age)
p1=superbPlot( Orange.wide, WSFactor = "age(7)",
  variables = c("circ_118","circ_484","circ_664","circ_1004","circ_1231","circ_1372","circ_1582"),
  adjustments = list(purpose = "difference", decorrelation = "none"), Quiet = TRUE
) + 
  xlab("Age level") + ylab("Trunk diameter (mm)") +
  coord_cartesian( ylim = c(0,250) ) + labs(title="Basic confidence intervals")
p2=superbPlot( Orange.wide, WSFactor = "age(7)",
  variables = c("circ_118","circ_484","circ_664","circ_1004","circ_1231","circ_1372","circ_1582"),
  adjustments = list(purpose = "difference", decorrelation = "CM"), Quiet = TRUE
) + 
  xlab("Age level") + ylab("Trunk diameter (mm)") +
  coord_cartesian( ylim = c(0,250) ) + labs(title="Decorrelated confidence intervals")
grid.arrange(p1,p2,ncol=2)


}
\references{
\insertAllCited{}
}
