% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supc1.R
\name{plot.supc}
\alias{plot.supc}
\title{Draw plots of the clustering result}
\usage{
\method{plot}{supc}(x, type = "heatmap", ...)
}
\arguments{
\item{x}{\code{supc} object to plot.}

\item{type}{character value. \itemize{
 \item{\code{"heatmap"}}{draw a heatmap to show the result of clustering. The clusters whose size is greater than parameter \code{major.size} are treated as major clusters.}
}}

\item{...}{other parameters to be passed through.}
}
\description{
General function to draw plots for analysis
}
\examples{
\dontrun{
data(golub, package = "supc")
golub.supc <- supc1(golub, rp = 0.0005, t = "dynamic")
table(golub.supc$size)
plot(golub.supc, type = "heatmap", major.size = 10)
}

}
