% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summclust_lm.R
\name{summclust.lm}
\alias{summclust.lm}
\title{Compute Influence and Leverage Metrics for objects of type \code{lm}}
\usage{
\method{summclust}{lm}(obj, cluster, params, type = "CRV3", ...)
}
\arguments{
\item{obj}{An object of type lm}

\item{cluster}{A clustering vector}

\item{params}{A character vector of variables for which leverage statistics
should be computed.}

\item{type}{"CRV3" or "CRV3J" following MacKinnon, Nielsen & Webb.
CRV3 by default}

\item{...}{other function arguments passed to 'vcov'}
}
\value{
An object of type \code{summclust}, including
a CRV3 variance-covariance estimate as described in
MacKinnon, Nielsen & Webb (2022)

\item{coef_estimates}{The coefficient estimates of the linear model.}
\item{vcov}{A CRV3 or CRV3J variance-covariance matrix estimate
as described in MacKinnon, Nielsen & Webb (2022)}
\item{leverage_g}{A vector of leverages.}
\item{leverage_avg}{The cluster leverage.}
\item{partial_leverage}{The partial leverages.}
\item{beta_jack}{The jackknifed' leave-on-cluster-out
regression coefficients.}
\item{params}{The input parameter vector 'params'.}
\item{N_G}{The number of clusters- }
\item{call}{The \code{summclust()} function call.}
\item{cluster}{The names of the clusters.}
}
\description{
Compute influence and leverage metrics for clustered inference
based on the Cluster Jackknife as described in MacKinnon, Nielsen & Webb
(2022) for objects of type \code{lm}.
}
\examples{
\donttest{
if(requireNamespace("summclust") && requireNamespace("haven")){

library(summclust)
library(haven)

nlswork <- read_dta("http://www.stata-press.com/data/r9/nlswork.dta")
# drop NAs at the moment
nlswork <- nlswork[, c("ln_wage", "grade", "age", "birth_yr", "union", "race", "msp", "ind_code")]
nlswork <- na.omit(nlswork)

lm_fit <- lm(
  ln_wage ~ union +  race + msp + as.factor(birth_yr) + as.factor(age) + as.factor(grade),
  data = nlswork)

res <- summclust(
   obj = lm_fit,
   cluster = ~ind_code,
   params = c("msp", "union")
 )

 summary(res)
 tidy(res)
 plot(res)
}
}
}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
