\name{save_dictionary}
\alias{save_dictionary}
\title{Save a Sumerian Dictionary to File}
\description{
Saves a Sumerian dictionary data frame to a semicolon-separated text file
with a metadata header containing author, year, version, and URL information.
}
\usage{
save_dictionary(dic, file, author = "", year = "", version = "", url = "")
}
\arguments{
\item{dic}{A dictionary data frame, typically created by
\code{\link{make_dictionary}} or \code{\link{convert_to_dictionary}}.
Must contain columns \code{sign_name}, \code{row_type}, \code{count},
\code{type}, and \code{meaning}.}

\item{file}{A character string specifying the output file path.}

\item{author}{A character string with the author name(s) for the metadata header.}

\item{year}{A character string with the year of creation for the metadata header.}

\item{version}{A character string with the version number for the metadata header.}

\item{url}{A character string with a URL where updates can be found.}
}
\value{
No return value. The function is called for its side effect of writing the
dictionary to a file.
}
\details{
\subsection{Output Format}{
The output file consists of two parts:

\enumerate{
\item A metadata header with lines starting with \code{###}, containing
author, year, version, and URL information
\item The dictionary data in semicolon-separated format with columns:
\code{sign_name}, \code{row_type}, \code{count}, \code{type}, \code{meaning}
}

Example output:
\preformatted{
###---------------------------------------------------------------
###                Sumerian Dictionary
###
### Author:  Robin Wellmann
### Year:    2026
### Version: 1.0
### Watch for Updates: https://founder-hypothesis.com/sumer/
###---------------------------------------------------------------
sign_name;row_type;count;type;meaning
A;cunei.;;;<cuneiform sign for A>
A;reading;;;{a, dur5, duru5}
A;trans.;3;S;water
}
}


}

\seealso{
\code{\link{make_dictionary}} and \code{\link{convert_to_dictionary}} for
creating dictionaries, \code{\link{read_dictionary}} for reading saved
dictionaries.
}
\examples{
\donttest{
# Create and save a dictionary

filename  <- system.file("extdata", "text_with_translations.txt", package = "sumer")
dictionary <- make_dictionary(filename)

save_dictionary(
  dic     = dictionary,
  file    = "sumerian_dictionary.txt",
  author  = "John Doe",
  year    = "2024",
  version = "1.0",
  url     = "https://example.com/dictionary"
)
}
}
