% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extras.R
\name{extras}
\alias{extras}
\title{Add standard styling and formatting to gtsummary tables}
\usage{
extras(tbl, pval = TRUE, overall = TRUE, last = FALSE, .args = NULL)
}
\arguments{
\item{tbl}{A gtsummary table object (e.g., from \code{tbl_summary()}, \code{tbl_regression()})}

\item{pval}{Logical indicating whether to add p-values. Default is \code{TRUE}.
When \code{TRUE}, uses gtsummary's default statistical tests (Kruskal-Wallis for
continuous variables with 3+ groups, chi-square for categorical variables).}

\item{overall}{Logical indicating whether to add overall column}

\item{last}{Logical indicating if Overall column should be last. Aligns with default
from \code{gtsummary::add_overall()}.}

\item{.args}{Optional list of arguments to use instead of individual parameters.
When provided, overrides \code{pval}, \code{overall}, and \code{last} arguments.}
}
\value{
A gtsummary table object with standard formatting applied
}
\description{
Applies a consistent set of formatting options to gtsummary tables
including overall column, bold labels, clean headers, and optional p-values.
Streamlines the common workflow of adding multiple formatting functions.
The function always succeeds by applying what works and warning about unsupported features.
}
\details{
The function applies the following modifications:
\itemize{
\item Bolds variable labels for emphasis (all table types)
\item Removes the "Characteristic" header label (all table types)
\item Adds an "Overall" column (only stratified summary tables)
\item Optionally adds p-values (only stratified summary tables)
\item Applies \code{clean_table()} styling (all table types)
}

The function automatically detects whether the input table is stratified (has a \code{by}
argument) and what type of table it is (tbl_summary, tbl_regression, tbl_strata, etc.).

For tables that don't support overall columns or p-values (non-stratified tables,
regression tables, or stacked tables), the function will issue a warning and
continue by applying only the universally supported features (bold_labels and
modify_header). This ensures the function always succeeds rather than failing
midway through the pipeline.

If any individual formatting step fails (e.g., due to unexpected table structure),
the function will issue a warning and continue without that feature. This provides
robustness while keeping you informed of what was skipped.
}
\section{Table Type Support}{

The function applies features based on table type and stratification:

\itemize{
\item \strong{bold_labels()} and \strong{modify_header()}: Work on all table types
\item \strong{add_overall()}: Only works on stratified summary tables (tbl_summary with \code{by})
\item \strong{add_p()}: Only works on stratified summary tables (tbl_summary with \code{by})
}

\strong{Full feature support:} tbl_summary and tbl_svysummary with \code{by} argument

\strong{Partial support (basic formatting only):} tbl_regression, tbl_strata, and
non-stratified tables. When applied to these table types and overall/pval = TRUE,
the function warns about unsupported features but applies the formatting that works.
}

\examples{
\donttest{
# With p-values (default)
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras()

# Using .args list
extra_args <- list(pval = TRUE, overall = TRUE, last = FALSE)
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras(.args = extra_args)

# Without p-values
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  extras(pval = FALSE)

# Chain with other functions
# Create required dictionary first
dictionary <- tibble::tribble(
  ~Variable, ~Description,
  'record_id', 'Participant ID',
  'age', 'Age at enrollment',
  'sex', 'Biological sex'
)
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  add_auto_labels() |>
  extras(pval = TRUE) |>
  add_group_styling()
}

}
\seealso{
\itemize{
\item \code{gtsummary::add_overall()} for adding overall columns
\item \code{gtsummary::add_p()} for adding p-values
\item \code{clean_table()} for additional table styling
}
}
