% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet-calendar.R
\docType{data}
\name{facet_calendar}
\alias{facet_calendar}
\alias{FacetCalendar}
\title{Lay out panels in a calendar format}
\usage{
facet_calendar(date, format = "\%b \%d",
  week_start = getOption("lubridate.week.start", 1), nrow = NULL,
  ncol = NULL, scales = "fixed", shrink = TRUE, dir = "h",
  labeller = "label_value", strip.position = "top")
}
\arguments{
\item{date}{A variable that contains dates will be mapped in the calendar.}

\item{format}{A character string, such as \code{\%Y-\%b-\%d} and \code{\%a (\%d)}, formatting
the display of facet strips. See \code{?strptime} for details.}

\item{week_start}{Day on which week starts following ISO conventions -
1 means Monday, 7 means Sunday (default). You can set \code{lubridate.week.start}
option to control this parameter globally.}

\item{nrow, ncol}{Number of rows and columns defined for "monthly" calendar
layout. If \code{NULL}, it computes a sensible layout.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{dir}{Direction of calendar: "h" for horizontal (the default) or "v" for
vertical.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with formulae of the type \code{~cyl + am}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[=labeller]{labeller()}}. See
\code{\link[=label_value]{label_value()}} for more details and pointers to other
options.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}
}
\description{
Lay out panels in a calendar format
}
\details{
A monthly calendar is set up as a 5 by 7 layout matrix. Each month could
extend over six weeks but in these months is to wrap the last few days up
to the top row of the block.
}
\examples{
\donttest{
fs <- pedestrian \%>\%
  dplyr::filter(Date < as.Date("2016-05-01"))

fs \%>\%
  ggplot(aes(x = Time, y = Hourly_Counts)) +
  geom_line(aes(colour = Sensor_Name)) +
  facet_calendar(~ Date, nrow = 2) +
  theme(legend.position = "bottom")
}
}
\seealso{
\link{frame_calendar} for a compact calendar display, by quickly transforming
the data.
}
\keyword{datasets}
