/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Instance;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class AttributeExpression
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = 402130123261736245L;
    private Stack<String> m_operatorStack = new Stack();
    private static final String OPERATORS = "+-*/()^lbcesfhrtn";
    private static final String UNARY_FUNCTIONS = "lbcesfhrtn";
    private String m_originalInfix;
    private Vector<ExpressionComponent> m_postFixExpVector;
    private boolean m_signMod = false;
    private String m_previousTok = "";

    private void handleOperand(String tok) throws Exception {
        if (tok.indexOf(97) != -1) {
            this.m_postFixExpVector.addElement(new AttributeOperand(tok, this.m_signMod));
        } else {
            try {
                this.m_postFixExpVector.addElement(new NumericOperand(tok, this.m_signMod));
            }
            catch (NumberFormatException ne) {
                throw new Exception("Trouble parsing numeric constant");
            }
        }
        this.m_signMod = false;
    }

    private void handleOperator(String tok) throws Exception {
        boolean push = true;
        char tokchar = tok.charAt(0);
        if (tokchar == ')') {
            String popop = " ";
            do {
                if ((popop = this.m_operatorStack.pop()).charAt(0) == '(') continue;
                this.m_postFixExpVector.addElement(new Operator(popop.charAt(0)));
            } while (popop.charAt(0) != '(');
        } else {
            int infixToc = this.infixPriority(tok.charAt(0));
            while (!this.m_operatorStack.empty() && this.stackPriority(this.m_operatorStack.peek().charAt(0)) >= infixToc) {
                if (this.m_previousTok.length() == 1 && this.isOperator(this.m_previousTok.charAt(0)) && this.m_previousTok.charAt(0) != ')') {
                    this.m_signMod = tok.charAt(0) == '-';
                    push = false;
                    break;
                }
                String popop = this.m_operatorStack.pop();
                this.m_postFixExpVector.addElement(new Operator(popop.charAt(0)));
            }
            if (this.m_postFixExpVector.size() == 0 && tok.charAt(0) == '-') {
                this.m_signMod = true;
                push = false;
            }
            if (push) {
                this.m_operatorStack.push(tok);
            }
        }
    }

    public void convertInfixToPostfix(String infixExp) throws Exception {
        this.m_originalInfix = infixExp;
        infixExp = Utils.removeSubstring(infixExp, " ");
        infixExp = Utils.replaceSubstring(infixExp, "log", "l");
        infixExp = Utils.replaceSubstring(infixExp, "abs", "b");
        infixExp = Utils.replaceSubstring(infixExp, "cos", "c");
        infixExp = Utils.replaceSubstring(infixExp, "exp", "e");
        infixExp = Utils.replaceSubstring(infixExp, "sqrt", "s");
        infixExp = Utils.replaceSubstring(infixExp, "floor", "f");
        infixExp = Utils.replaceSubstring(infixExp, "ceil", "h");
        infixExp = Utils.replaceSubstring(infixExp, "rint", "r");
        infixExp = Utils.replaceSubstring(infixExp, "tan", "t");
        infixExp = Utils.replaceSubstring(infixExp, "sin", "n");
        StringTokenizer tokenizer = new StringTokenizer(infixExp, OPERATORS, true);
        this.m_postFixExpVector = new Vector();
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.length() > 1) {
                this.handleOperand(tok);
            } else if (this.isOperator(tok.charAt(0))) {
                this.handleOperator(tok);
            } else {
                this.handleOperand(tok);
            }
            this.m_previousTok = tok;
        }
        while (!this.m_operatorStack.empty()) {
            String popop = this.m_operatorStack.pop();
            if (popop.charAt(0) == '(' || popop.charAt(0) == ')') {
                throw new Exception("Mis-matched parenthesis!");
            }
            this.m_postFixExpVector.addElement(new Operator(popop.charAt(0)));
        }
    }

    public double evaluateExpression(Instance instance) throws Exception {
        double[] vals = new double[instance.numAttributes() + 1];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            vals[i] = instance.isMissing(i) ? Utils.missingValue() : instance.value(i);
        }
        this.evaluateExpression(vals);
        return vals[vals.length - 1];
    }

    public void evaluateExpression(double[] vals) throws Exception {
        Stack<Double> operands = new Stack<Double>();
        for (int i = 0; i < this.m_postFixExpVector.size(); ++i) {
            ExpressionComponent nextob = this.m_postFixExpVector.elementAt(i);
            if (nextob instanceof NumericOperand) {
                operands.push(new Double(((NumericOperand)nextob).m_numericConst));
                continue;
            }
            if (nextob instanceof AttributeOperand) {
                double value = vals[((AttributeOperand)nextob).m_attributeIndex];
                if (((AttributeOperand)nextob).m_negative) {
                    value = -value;
                }
                operands.push(new Double(value));
                continue;
            }
            if (nextob instanceof Operator) {
                char op = ((Operator)nextob).m_operator;
                if (this.isUnaryFunction(op)) {
                    double operand = (Double)operands.pop();
                    double result = ((Operator)nextob).applyFunction(operand);
                    operands.push(new Double(result));
                    continue;
                }
                double second = (Double)operands.pop();
                double first = (Double)operands.pop();
                double result = ((Operator)nextob).applyOperator(first, second);
                operands.push(new Double(result));
                continue;
            }
            throw new Exception("Unknown object in postfix vector!");
        }
        if (operands.size() != 1) {
            throw new Exception("Problem applying function");
        }
        Double result = (Double)operands.pop();
        vals[vals.length - 1] = result.isNaN() || result.isInfinite() ? Utils.missingValue() : result;
    }

    private boolean isOperator(char tok) {
        return OPERATORS.indexOf(tok) != -1;
    }

    private boolean isUnaryFunction(char tok) {
        return UNARY_FUNCTIONS.indexOf(tok) != -1;
    }

    private int infixPriority(char opp) {
        switch (opp) {
            case 'b': 
            case 'c': 
            case 'e': 
            case 'f': 
            case 'h': 
            case 'l': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': {
                return 3;
            }
            case '^': {
                return 2;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 2;
            }
            case '+': {
                return 1;
            }
            case '-': {
                return 1;
            }
            case '(': {
                return 4;
            }
            case ')': {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unrecognized operator:" + opp);
    }

    private int stackPriority(char opp) {
        switch (opp) {
            case 'b': 
            case 'c': 
            case 'e': 
            case 'f': 
            case 'h': 
            case 'l': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': {
                return 3;
            }
            case '^': {
                return 2;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 2;
            }
            case '+': {
                return 1;
            }
            case '-': {
                return 1;
            }
            case '(': {
                return 0;
            }
            case ')': {
                return -1;
            }
        }
        throw new IllegalArgumentException("Unrecognized operator:" + opp);
    }

    public String getPostFixExpression() {
        return this.m_postFixExpVector.toString();
    }

    public String toString() {
        return this.m_originalInfix;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5988 $");
    }

    private class Operator
    implements ExpressionComponent,
    Serializable,
    RevisionHandler {
        static final long serialVersionUID = -2760353522666004638L;
        protected char m_operator;

        public Operator(char opp) {
            if (!AttributeExpression.this.isOperator(opp)) {
                throw new IllegalArgumentException("Unrecognized operator:" + opp);
            }
            this.m_operator = opp;
        }

        protected double applyOperator(double first, double second) {
            switch (this.m_operator) {
                case '+': {
                    return first + second;
                }
                case '-': {
                    return first - second;
                }
                case '*': {
                    return first * second;
                }
                case '/': {
                    return first / second;
                }
                case '^': {
                    return Math.pow(first, second);
                }
            }
            return Double.NaN;
        }

        protected double applyFunction(double value) {
            switch (this.m_operator) {
                case 'l': {
                    return Math.log(value);
                }
                case 'b': {
                    return Math.abs(value);
                }
                case 'c': {
                    return Math.cos(value);
                }
                case 'e': {
                    return Math.exp(value);
                }
                case 's': {
                    return Math.sqrt(value);
                }
                case 'f': {
                    return Math.floor(value);
                }
                case 'h': {
                    return Math.ceil(value);
                }
                case 'r': {
                    return Math.rint(value);
                }
                case 't': {
                    return Math.tan(value);
                }
                case 'n': {
                    return Math.sin(value);
                }
            }
            return Double.NaN;
        }

        public String toString() {
            return "" + this.m_operator;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5988 $");
        }
    }

    private class NumericOperand
    implements ExpressionComponent,
    Serializable,
    RevisionHandler {
        static final long serialVersionUID = 9037007836243662859L;
        protected double m_numericConst;

        public NumericOperand(String operand, boolean sign) throws Exception {
            this.m_numericConst = Double.valueOf(operand);
            if (sign) {
                this.m_numericConst *= -1.0;
            }
        }

        public String toString() {
            return "" + this.m_numericConst;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5988 $");
        }
    }

    private class AttributeOperand
    implements ExpressionComponent,
    Serializable,
    RevisionHandler {
        static final long serialVersionUID = -7674280127286031105L;
        protected int m_attributeIndex;
        protected boolean m_negative;

        public AttributeOperand(String operand, boolean sign) throws Exception {
            this.m_attributeIndex = Integer.parseInt(operand.substring(1)) - 1;
            this.m_negative = sign;
        }

        public String toString() {
            String result = "";
            if (this.m_negative) {
                result = result + '-';
            }
            return result + "a" + (this.m_attributeIndex + 1);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5988 $");
        }
    }

    private static interface ExpressionComponent {
    }
}

