% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylerignore.R
\name{stylerignore_consolidate_col}
\alias{stylerignore_consolidate_col}
\title{Consolidate columns after a merge}
\usage{
stylerignore_consolidate_col(
  flattened_pd,
  col,
  col_x = paste0(col, ".x"),
  col_y = paste0(col, ".y")
)
}
\arguments{
\item{flattened_pd}{A flattened parse table.}

\item{col}{A string indicating the name of the column that should be
consolidated.}

\item{col_x, col_y}{The name of the column from the left (right) parent to
consolidate.}
}
\description{
After \code{\link[base:merge]{base::merge()}}, all non-id columns that were present in \code{x} and \code{y}
do get a suffix \code{.x} and \code{.y}. If the \code{y} value is missing, use the \code{x}
value (because the information for this token was not stylerignored),
otherwise the \code{y} value (i.e. the styled value).
}
\keyword{internal}
