% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeArtefact.r
\name{removeArtefact}
\alias{removeArtefact}
\title{Remove Artefacts}
\usage{
removeArtefact(data, artefact = NULL, marker = NULL, allele = NULL,
  threshold = NULL, na.rm = FALSE, debug = FALSE)
}
\arguments{
\item{data}{data.frame with data to remove spikes from.}

\item{artefact}{data.frame that lists artefacts in columns 'Marker',
'Allele', optionally with 'Allele.Proportion'.
Alternatively artefacts can be provided using 'marker' and 'allele'.}

\item{marker}{character vector with marker names paired with values in 'allele'.}

\item{allele}{character vector with allele names paired with values in 'marker'.}

\item{threshold}{numeric value defining a minimum proportion for artefacts.
Requires 'artefacts' including the column 'Allele.Proportion'.}

\item{na.rm}{logical TRUE to preserve Allele=NA in 'data'.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with spikes removed.
}
\description{
Remove artefact peaks from data.
}
\details{
Removes identified artefacts from the dataset. Likely artefacts can be
identified using the function \code{\link{calculateAllele}}. The output
should then be provided to the 'artefact'. Alternatively known artefacts
can be provided using the 'marker' and 'allele' arguments.
}

