% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{str_order}
\alias{str_order}
\alias{str_sort}
\title{Order or sort a character vector.}
\usage{
str_order(x, decreasing = FALSE, na_last = TRUE, locale = "en",
  numeric = FALSE, ...)

str_sort(x, decreasing = FALSE, na_last = TRUE, locale = "en",
  numeric = FALSE, ...)
}
\arguments{
\item{x}{A character vector to sort.}

\item{decreasing}{A boolean. If \code{FALSE}, the default, sorts from
lowest to highest; if \code{TRUE} sorts from highest to lowest.}

\item{na_last}{Where should \code{NA} go? \code{TRUE} at the end,
\code{FALSE} at the beginning, \code{NA} dropped.}

\item{locale}{In which locale should the sorting occur? Defaults to
the English. This ensures that code behaves the same way across
platforms.}

\item{numeric}{If \code{TRUE}, will sort digits numerically, instead
of as strings.}

\item{...}{Other options used to control sorting order. Passed on to
\code{\link[stringi]{stri_opts_collator}}.}
}
\description{
Order or sort a character vector.
}
\examples{
str_order(letters)
str_sort(letters)

str_order(letters, locale = "haw")
str_sort(letters, locale = "haw")

x <- c("100a10", "100a5", "2b", "2a")
str_sort(x)
str_sort(x, numeric = TRUE)
}
\seealso{
\code{\link[stringi]{stri_order}} for the underlying implementation.
}
