% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stringi-search-fixed}
\alias{stringi-search-fixed}
\title{Locale-Insensitive Fixed Pattern Matching in \pkg{stringi}}
\description{
String searching facilities described in this very man page
provide a way to locate a specific piece of
text. Note that locale-sensitive searching, especially
on a non-English language text, is a much more complex process
than it seems at the first glance.
}
\section{Byte Compare}{


The Knuth-Morris-Pratt search algorithm, with worst time complexity of
O(n+p) (\code{n == length(str)}, \code{p == length(pattern)})
is utilized (with some tweaks for very short search patterns).
For natural language processing, however, this is not what
you probably want. It is because a bitwise match will
not give correct results in cases of:
\enumerate{
\item accented letters;
\item conjoined letters;
\item ignorable punctuation;
\item ignorable case,
}
see also \link{stringi-search-coll}.

Note that, the conversion of input data
to Unicode is done as usual.
}
\seealso{
Other search_fixed: \code{\link{stri_count_fixed}};
  \code{\link{stri_detect_fixed}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_replace_all_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_last_fixed}},
  \code{\link{stri_replace_last_fixed}};
  \code{\link{stri_split_fixed}};
  \code{\link{stringi-search}}

Other stringi_general_topics: \code{\link{stringi-arguments}};
  \code{\link{stringi-encoding}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-package}};
  \code{\link{stringi-search-charclass}};
  \code{\link{stringi-search-coll}};
  \code{\link{stringi-search-regex}};
  \code{\link{stringi-search}}
}

