% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_files.R
\name{sf_grepl}
\alias{sf_grepl}
\title{sf_grepl}
\usage{
sf_grepl(subject, pattern, encode_mode = "auto")
}
\arguments{
\item{subject}{The subject character vector to search}

\item{pattern}{The pattern to search for}

\item{encode_mode}{The encoding type to use (UTF-8, latin1, bytes, native or auto)}
}
\value{
A logical vector with the same length as subject
}
\description{
A function that matches patterns and returns a logical vector
}
\details{
The function uses the PCRE2 library, which is also used internally by R. 
The encoding is based on the pattern string (or forced via the encode_mode parameter). 
Note: the order of paramters is switched compared to the `grepl` base R function, with subject being first. 
See also: https://www.pcre.org/current/doc/html/pcre2api.html for more documentation on match syntax.
}
\examples{
x <- sf_vector(10)
sf_assign(x, 1, "hello world")
pattern <- "^hello"
sf_grepl(x, pattern)
}
\seealso{
grepl
}
