% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stringsim.R
\name{stringsim}
\alias{stringsim}
\title{Compute similarity scores between strings}
\usage{
stringsim(a, b, method = c("osa", "lv", "dl", "hamming", "lcs", "qgram",
  "cosine", "jaccard", "jw", "soundex"), useBytes = FALSE, q = 1, ...)
}
\arguments{
\item{a}{R object (target); will be converted by \code{as.character}.}

\item{b}{R object (source); will be converted by \code{as.character}.}

\item{method}{Method for distance calculation. The default is \code{"osa"},
see \code{\link{stringdist-metrics}}.}

\item{useBytes}{Perform byte-wise comparison, see \code{\link{stringdist-encoding}}.}

\item{q}{Size of the \eqn{q}-gram; must be nonnegative. Only applies to
\code{method='qgram'}, \code{'jaccard'} or \code{'cosine'}.}

\item{...}{additional arguments are passed on to \code{\link{stringdist}}.}
}
\value{
Returns a vector with similarities, which are values between 0 and 1 where
1 corresponds to perfect similarity (distance 0) and 0 to complete
dissimilarity. \code{NA} is returned when \code{\link{stringdist}} returns
\code{NA}. Distances equal to \code{Inf} are truncated to a similarity of
0.
}
\description{
\code{stringsim} computes pairwise string similarities between elements of
\code{character} vectors \code{a} and \code{b}, where the vector with less
elements is recycled.
}
\details{
The similarity is calculated by first calculating the distance using
\code{\link{stringdist}} and then dividing the distance by the maximum
possible distance. This results in a score between 0 and 1, with 1
corresponding to perfect similarity and 0 to complete dissimilarity.
For distances where weights can be specified, the maximum distance is currently computed by
assuming that all weights are equal to 1.
}
\examples{


# Calculate the similarity using the default method of optimal string alignment
stringsim("ca", "abc")

# Calculate the similarity using the Jaro-Winkler method
# The p argument is passed on to stringdist
stringsim('MARTHA','MATHRA',method='jw', p=0.1)

}

