% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/currency.R
\name{currency}
\alias{currency}
\alias{str_get_currencies}
\alias{str_get_currency}
\title{Get the currencies of numbers within a string.}
\usage{
str_get_currencies(string)

str_get_currency(string)
}
\arguments{
\item{string}{A string for \code{get_currencies()} and a character vector for
\code{get_currency()}.}
}
\value{
\itemize{ \item \code{get_currency} returns a character vector. \item
\code{get_currencies} returns a data frame with one column for the currency symbol
and one for the amount. }
}
\description{
The currency of a number is defined as the character coming before the number
in the string. If nothing comes before (i.e. if the number is the first thing
in the string), the currency is the empty string, similarly the currency can
be a space, comma or any manner of thing. \itemize{ \item \code{get_currency}
takes a string and returns the currency of the first number therein. It is
vectorized over string. \item \code{get_currencies} takes a string and returns the
currencies of all of the numbers within that string. It is not vectorized. }
}
\details{
These functions do not allow for leading decimal points.
}
\examples{
str_get_currencies("35.00 $1.14 abc5 $3.8 77")
str_get_currency(c("ab3 13", "$1"))
}
