/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.active;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import moa.evaluation.ALMeasureCollection;
import moa.evaluation.MeasureCollection;
import moa.evaluation.preview.MeanPreviewCollection;
import moa.evaluation.preview.Preview;
import moa.evaluation.preview.PreviewCollection;
import moa.gui.FileExtensionFilter;
import moa.gui.GUIUtils;
import moa.gui.PreviewTableModel;
import moa.gui.active.MeasureOverview;
import moa.gui.visualization.ParamGraphCanvas;
import moa.gui.visualization.ProcessGraphCanvas;
import moa.tasks.FailedTaskReport;
import moa.tasks.meta.ALMultiParamTask;
import moa.tasks.meta.ALPartitionEvaluationTask;
import moa.tasks.meta.ALPrequentialEvaluationTask;
import nz.ac.waikato.cms.gui.core.BaseFileChooser;

public class ALTaskTextViewerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String EXPORT_FILE_EXTENSION = "txt";
    private JSplitPane mainPane;
    private JPanel topWrapper;
    private PreviewTableModel previewTableModel;
    private JTable previewTable;
    private JTextArea errorTextField;
    private JScrollPane scrollPaneTable;
    private JScrollPane scrollPaneText;
    private JButton exportButton;
    private JPanel panelEvalOutput;
    private MeasureOverview measureOverview;
    private GridBagConstraints gridBagConstraints;
    private JPanel graphPanel;
    private JPanel graphPanelControlLeft;
    private JButton buttonZoomInY;
    private JButton buttonZoomOutY;
    private JLabel labelEvents;
    private JTabbedPane graphPanelTabbedPane;
    private JScrollPane graphScrollPanel;
    private ProcessGraphCanvas graphCanvas;
    private JScrollPane paramGraphScrollPanel;
    private ParamGraphCanvas paramGraphCanvas;
    private JScrollPane budgetGraphScrollPanel;
    private ParamGraphCanvas budgetGraphCanvas;
    private JPanel graphPanelControlRight;
    private JButton buttonZoomInX;
    private JButton buttonZoomOutX;
    private String variedParamName;
    private double[] variedParamValues;
    private double[] budgets;

    public ALTaskTextViewerPanel() {
        this.setLayout(new GridBagLayout());
        this.mainPane = new JSplitPane(0);
        this.mainPane.setDividerLocation(200);
        this.topWrapper = new JPanel();
        this.topWrapper.setLayout(new BorderLayout());
        this.previewTableModel = new PreviewTableModel();
        this.previewTable = new JTable(this.previewTableModel);
        this.previewTable.setFont(new Font("Monospaced", 0, 12));
        this.previewTable.setAutoResizeMode(0);
        this.errorTextField = new JTextArea();
        this.errorTextField.setEditable(false);
        this.errorTextField.setFont(new Font("Monospaced", 0, 12));
        this.scrollPaneTable = new JScrollPane(this.previewTable, 20, 30);
        this.scrollPaneText = new JScrollPane(this.errorTextField, 20, 30);
        this.scrollPaneText.setVisible(false);
        this.topWrapper.add((Component)this.scrollPaneTable, "Center");
        JPanel exportButtonWrapper = new JPanel();
        exportButtonWrapper.setLayout(new GridLayout(1, 2));
        this.exportButton = new JButton("Export as .txt file...");
        this.exportButton.setEnabled(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseFileChooser fileChooser = new BaseFileChooser();
                fileChooser.setAcceptAllFileFilterUsed(true);
                fileChooser.addChoosableFileFilter((FileFilter)new FileExtensionFilter(ALTaskTextViewerPanel.EXPORT_FILE_EXTENSION));
                if (fileChooser.showSaveDialog((Component)ALTaskTextViewerPanel.this) == 0) {
                    File chosenFile = fileChooser.getSelectedFile();
                    String fileName = chosenFile.getPath();
                    if (!chosenFile.exists() && !fileName.endsWith(ALTaskTextViewerPanel.EXPORT_FILE_EXTENSION)) {
                        fileName = fileName + "." + ALTaskTextViewerPanel.EXPORT_FILE_EXTENSION;
                    }
                    try {
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                        String text = "";
                        text = ALTaskTextViewerPanel.this.scrollPaneTable.isVisible() ? ALTaskTextViewerPanel.this.previewTableModel.toString() : ALTaskTextViewerPanel.this.errorTextField.getText();
                        out.write(text);
                        out.close();
                    }
                    catch (IOException ioe) {
                        GUIUtils.showExceptionDialog(ALTaskTextViewerPanel.this.exportButton, "Problem saving file " + fileName, ioe);
                    }
                }
            }
        });
        exportButtonWrapper.add(this.exportButton);
        this.topWrapper.add((Component)exportButtonWrapper, "South");
        this.mainPane.setTopComponent(this.topWrapper);
        this.panelEvalOutput = new JPanel();
        this.panelEvalOutput.setLayout(new GridBagLayout());
        this.panelEvalOutput.setBorder(BorderFactory.createTitledBorder("Evaluation"));
        this.measureOverview = new MeasureOverview(new ALMeasureCollection[]{new ALMeasureCollection()}, "", null);
        this.measureOverview.setMinimumSize(new Dimension(280, 118));
        this.measureOverview.setPreferredSize(new Dimension(290, 115));
        this.measureOverview.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = Integer.parseInt(e.getActionCommand());
                ALTaskTextViewerPanel.this.graphCanvas.setMeasureSelected(selected);
                ALTaskTextViewerPanel.this.graphCanvas.updateCanvas(true);
                ALTaskTextViewerPanel.this.paramGraphCanvas.setMeasureSelected(selected);
                ALTaskTextViewerPanel.this.paramGraphCanvas.updateCanvas(true);
                ALTaskTextViewerPanel.this.budgetGraphCanvas.setMeasureSelected(selected);
                ALTaskTextViewerPanel.this.budgetGraphCanvas.updateCanvas(true);
            }
        });
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.weighty = 1.0;
        this.panelEvalOutput.add((Component)this.measureOverview, this.gridBagConstraints);
        this.graphPanel = new JPanel();
        this.graphPanel.setLayout(new GridBagLayout());
        this.graphPanel.setBorder(BorderFactory.createTitledBorder("Plot"));
        this.graphPanel.setPreferredSize(new Dimension(530, 115));
        this.graphPanelControlLeft = new JPanel();
        this.graphPanelControlLeft.setLayout(new GridBagLayout());
        this.buttonZoomInY = new JButton();
        this.buttonZoomInY.setText("Zoom in Y");
        this.buttonZoomInY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int currentTab = ALTaskTextViewerPanel.this.graphPanelTabbedPane.getSelectedIndex();
                switch (currentTab) {
                    case 0: {
                        ALTaskTextViewerPanel.this.graphCanvas.scaleYResolution(2.0);
                        break;
                    }
                    case 1: {
                        ALTaskTextViewerPanel.this.paramGraphCanvas.scaleYResolution(2.0);
                        break;
                    }
                    case 2: {
                        ALTaskTextViewerPanel.this.budgetGraphCanvas.scaleYResolution(2.0);
                    }
                }
            }
        });
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlLeft.add((Component)this.buttonZoomInY, this.gridBagConstraints);
        this.buttonZoomOutY = new JButton();
        this.buttonZoomOutY.setText("Zoom out Y");
        this.buttonZoomOutY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int currentTab = ALTaskTextViewerPanel.this.graphPanelTabbedPane.getSelectedIndex();
                switch (currentTab) {
                    case 0: {
                        ALTaskTextViewerPanel.this.graphCanvas.scaleYResolution(0.5);
                        break;
                    }
                    case 1: {
                        ALTaskTextViewerPanel.this.paramGraphCanvas.scaleYResolution(0.5);
                        break;
                    }
                    case 2: {
                        ALTaskTextViewerPanel.this.budgetGraphCanvas.scaleYResolution(0.5);
                    }
                }
            }
        });
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlLeft.add((Component)this.buttonZoomOutY, this.gridBagConstraints);
        this.labelEvents = new JLabel();
        this.labelEvents.setHorizontalAlignment(0);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.graphPanelControlLeft.add((Component)this.labelEvents, this.gridBagConstraints);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.weightx = 1.0;
        this.graphPanel.add((Component)this.graphPanelControlLeft, this.gridBagConstraints);
        this.graphPanelTabbedPane = new JTabbedPane();
        this.graphScrollPanel = new JScrollPane();
        this.graphCanvas = new ProcessGraphCanvas();
        this.graphCanvas.setPreferredSize(new Dimension(500, 111));
        this.graphCanvas.setGraph(null, null, null, 1000, null);
        GroupLayout graphCanvasLayout = new GroupLayout(this.graphCanvas);
        this.graphCanvas.setLayout(graphCanvasLayout);
        graphCanvasLayout.setHorizontalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 515, Short.MAX_VALUE));
        graphCanvasLayout.setVerticalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        this.graphScrollPanel.setViewportView(this.graphCanvas);
        this.graphPanelTabbedPane.addTab("Processed Instances", this.graphScrollPanel);
        this.paramGraphScrollPanel = new JScrollPane();
        this.paramGraphCanvas = new ParamGraphCanvas();
        this.paramGraphCanvas.setPreferredSize(new Dimension(500, 111));
        this.paramGraphCanvas.setGraph(null, null, null, null);
        GroupLayout paramGraphCanvasLayout = new GroupLayout(this.paramGraphCanvas);
        this.paramGraphCanvas.setLayout(paramGraphCanvasLayout);
        paramGraphCanvasLayout.setHorizontalGroup(paramGraphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 515, Short.MAX_VALUE));
        paramGraphCanvasLayout.setVerticalGroup(paramGraphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        this.paramGraphScrollPanel.setViewportView(this.paramGraphCanvas);
        this.graphPanelTabbedPane.addTab("Varied Parameter", this.paramGraphScrollPanel);
        this.budgetGraphScrollPanel = new JScrollPane();
        this.budgetGraphCanvas = new ParamGraphCanvas();
        this.budgetGraphCanvas.setPreferredSize(new Dimension(500, 111));
        this.budgetGraphCanvas.setGraph(null, null, null, null);
        GroupLayout budgetGraphCanvasLayout = new GroupLayout(this.budgetGraphCanvas);
        this.budgetGraphCanvas.setLayout(budgetGraphCanvasLayout);
        budgetGraphCanvasLayout.setHorizontalGroup(budgetGraphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 515, Short.MAX_VALUE));
        budgetGraphCanvasLayout.setVerticalGroup(budgetGraphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        this.budgetGraphScrollPanel.setViewportView(this.budgetGraphCanvas);
        this.graphPanelTabbedPane.addTab("Label Acq. Rate", this.budgetGraphScrollPanel);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.gridwidth = 2;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.graphPanel.add((Component)this.graphPanelTabbedPane, this.gridBagConstraints);
        this.graphPanelControlRight = new JPanel();
        this.buttonZoomInX = new JButton();
        this.buttonZoomInX.setText("Zoom in X");
        this.buttonZoomInX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int currentTab = ALTaskTextViewerPanel.this.graphPanelTabbedPane.getSelectedIndex();
                switch (currentTab) {
                    case 0: {
                        ALTaskTextViewerPanel.this.graphCanvas.scaleXResolution(2.0);
                        break;
                    }
                    case 1: {
                        ALTaskTextViewerPanel.this.paramGraphCanvas.scaleXResolution(2.0);
                        break;
                    }
                    case 2: {
                        ALTaskTextViewerPanel.this.budgetGraphCanvas.scaleXResolution(2.0);
                    }
                }
            }
        });
        this.graphPanelControlRight.add(this.buttonZoomInX);
        this.buttonZoomOutX = new JButton();
        this.buttonZoomOutX.setText("Zoom out X");
        this.buttonZoomOutX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int currentTab = ALTaskTextViewerPanel.this.graphPanelTabbedPane.getSelectedIndex();
                switch (currentTab) {
                    case 0: {
                        ALTaskTextViewerPanel.this.graphCanvas.scaleXResolution(0.5);
                        break;
                    }
                    case 1: {
                        ALTaskTextViewerPanel.this.paramGraphCanvas.scaleXResolution(0.5);
                        break;
                    }
                    case 2: {
                        ALTaskTextViewerPanel.this.budgetGraphCanvas.scaleXResolution(0.5);
                    }
                }
            }
        });
        this.graphPanelControlRight.add(this.buttonZoomOutX);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 1;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.anchor = 13;
        this.graphPanel.add((Component)this.graphPanelControlRight, this.gridBagConstraints);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.anchor = 17;
        this.gridBagConstraints.weightx = 2.0;
        this.gridBagConstraints.weighty = 1.0;
        this.panelEvalOutput.add((Component)this.graphPanel, this.gridBagConstraints);
        this.mainPane.setBottomComponent(this.panelEvalOutput);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.add((Component)this.mainPane, this.gridBagConstraints);
    }

    public void setText(Preview preview) {
        Point p = this.scrollPaneTable.getViewport().getViewPosition();
        this.previewTableModel.setPreview(preview);
        SwingUtilities.invokeLater(new Runnable(){
            boolean structureChanged;
            {
                this.structureChanged = ALTaskTextViewerPanel.this.previewTableModel.structureChanged();
            }

            @Override
            public void run() {
                if (!ALTaskTextViewerPanel.this.scrollPaneTable.isVisible()) {
                    ALTaskTextViewerPanel.this.topWrapper.remove(ALTaskTextViewerPanel.this.scrollPaneText);
                    ALTaskTextViewerPanel.this.scrollPaneText.setVisible(false);
                    ALTaskTextViewerPanel.this.topWrapper.add((Component)ALTaskTextViewerPanel.this.scrollPaneTable, "Center");
                    ALTaskTextViewerPanel.this.scrollPaneTable.setVisible(true);
                    ALTaskTextViewerPanel.this.topWrapper.validate();
                }
                if (this.structureChanged) {
                    ALTaskTextViewerPanel.this.previewTableModel.fireTableStructureChanged();
                    ALTaskTextViewerPanel.this.rescaleTableColumns();
                } else {
                    ALTaskTextViewerPanel.this.previewTableModel.fireTableDataChanged();
                }
                ALTaskTextViewerPanel.this.previewTable.repaint();
            }
        });
        this.scrollPaneTable.getViewport().setViewPosition(p);
        this.exportButton.setEnabled(preview != null);
    }

    public void setErrorText(FailedTaskReport failedTaskReport) {
        Point p = this.scrollPaneText.getViewport().getViewPosition();
        final String failedTaskReportString = failedTaskReport == null ? "Failed Task Report is null" : failedTaskReport.toString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ALTaskTextViewerPanel.this.scrollPaneText.isVisible()) {
                    ALTaskTextViewerPanel.this.topWrapper.remove(ALTaskTextViewerPanel.this.scrollPaneTable);
                    ALTaskTextViewerPanel.this.scrollPaneTable.setVisible(false);
                    ALTaskTextViewerPanel.this.topWrapper.add((Component)ALTaskTextViewerPanel.this.scrollPaneText, "Center");
                    ALTaskTextViewerPanel.this.scrollPaneText.setVisible(true);
                    ALTaskTextViewerPanel.this.topWrapper.validate();
                }
                ALTaskTextViewerPanel.this.errorTextField.setText(failedTaskReportString);
                ALTaskTextViewerPanel.this.errorTextField.repaint();
            }
        });
        this.scrollPaneText.getViewport().setViewPosition(p);
        this.exportButton.setEnabled(failedTaskReport != null);
    }

    private void rescaleTableColumns() {
        TableColumnModel columnModel = this.previewTable.getColumnModel();
        for (int columnIdx = 0; columnIdx < columnModel.getColumnCount(); ++columnIdx) {
            TableColumn column = columnModel.getColumn(columnIdx);
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.previewTable.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.previewTable, column.getHeaderValue(), false, false, 0, columnIdx);
            int width = comp.getPreferredSize().width;
            column.setPreferredWidth(width);
        }
    }

    public void setGraph(Preview preview, Color[] colors) {
        ParsedPreview ppStd;
        ParsedPreview pp;
        if (preview == null) {
            this.measureOverview.update(null, "", null);
            this.graphCanvas.setGraph(null, null, null, 1000, null);
            this.paramGraphCanvas.setGraph(null, null, null, null);
            this.budgetGraphCanvas.setGraph(null, null, null, null);
            return;
        }
        Class<?> c = preview.getTaskClass();
        if (c == ALPartitionEvaluationTask.class || c == ALMultiParamTask.class) {
            PreviewCollection pc = (PreviewCollection)preview;
            this.variedParamName = pc.getVariedParamName();
            this.variedParamValues = pc.getVariedParamValues();
            if (c == ALPartitionEvaluationTask.class) {
                MeanPreviewCollection mpc = new MeanPreviewCollection((PreviewCollection)preview);
                pp = this.readCollection(mpc.getMeanPreviews());
                ppStd = this.readCollection(mpc.getStdPreviews());
                this.graphCanvas.setStandardDeviationPainted(true);
                this.paramGraphCanvas.setStandardDeviationPainted(true);
            } else {
                pp = this.readCollection(pc);
                ppStd = null;
                this.graphCanvas.setStandardDeviationPainted(false);
                this.paramGraphCanvas.setStandardDeviationPainted(false);
            }
            this.graphPanelTabbedPane.setEnabledAt(1, true);
            this.graphPanelTabbedPane.setEnabledAt(2, true);
        } else if (c == ALPrequentialEvaluationTask.class) {
            pp = this.read(preview);
            ppStd = null;
            this.variedParamName = "";
            this.variedParamValues = null;
            this.graphPanelTabbedPane.setSelectedIndex(0);
            this.graphPanelTabbedPane.setEnabledAt(1, false);
            this.graphPanelTabbedPane.setEnabledAt(2, false);
            this.graphCanvas.setStandardDeviationPainted(false);
            this.paramGraphCanvas.setStandardDeviationPainted(false);
        } else {
            this.measureOverview.update(null, "", null);
            this.graphCanvas.setGraph(null, null, null, 1000, null);
            this.paramGraphCanvas.setGraph(null, null, null, null);
            this.budgetGraphCanvas.setGraph(null, null, null, null);
            return;
        }
        MeasureCollection[] measures = pp.getMeasureCollectionsArray();
        MeasureCollection[] measuresStd = null;
        if (ppStd != null) {
            measuresStd = ppStd.getMeasureCollectionsArray();
        }
        this.budgets = new double[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            this.budgets[i] = measures[i].getLastValue(6);
        }
        int[] pfs = pp.getProcessFrequenciesArray();
        int min_pf = ALTaskTextViewerPanel.min(pfs);
        this.measureOverview.update(measures, this.variedParamName, this.variedParamValues);
        this.graphCanvas.setGraph(measures, measuresStd, pfs, min_pf, colors);
        this.paramGraphCanvas.setGraph(measures, measuresStd, this.variedParamValues, colors);
        this.budgetGraphCanvas.setGraph(measures, measuresStd, this.budgets, colors);
    }

    private static int min(int[] l) {
        if (l.length == 0) {
            return 0;
        }
        int min = l[0];
        for (int i = 0; i < l.length; ++i) {
            if (l[i] >= min) continue;
            min = l[i];
        }
        return min;
    }

    public ParsedPreview readCollection(PreviewCollection<Preview> pc) {
        ParsedPreview pp = new ParsedPreview();
        List<Preview> sps = pc.getPreviews();
        if (sps.size() > 0 && sps.get(0) instanceof PreviewCollection) {
            for (Preview sp : sps) {
                ParsedPreview tmp = this.readCollection((PreviewCollection)sp);
                pp.add(tmp);
            }
        } else {
            for (Preview sp : sps) {
                ParsedPreview tmp = this.read(sp);
                pp.add(tmp);
            }
        }
        return pp;
    }

    private ParsedPreview read(Preview p) {
        String[] measureNames = p.getMeasurementNames();
        int numMeasures = p.getMeasurementNameCount();
        int processFrequencyColumn = -1;
        int accuracyColumn = -1;
        int kappaColumn = -1;
        int kappaTempColumn = -1;
        int ramColumn = -1;
        int timeColumn = -1;
        int memoryColumn = -1;
        int budgetColumn = -1;
        block31: for (int i = 0; i < numMeasures; ++i) {
            switch (measureNames[i]) {
                case "learning evaluation instances": {
                    processFrequencyColumn = i;
                    continue block31;
                }
                case "classifications correct (percent)": 
                case "[avg] classifications correct (percent)": 
                case "[std] classifications correct (percent)": {
                    accuracyColumn = i;
                    continue block31;
                }
                case "Kappa Statistic (percent)": 
                case "[avg] Kappa Statistic (percent)": 
                case "[std] Kappa Statistic (percent)": {
                    kappaColumn = i;
                    continue block31;
                }
                case "Kappa Temporal Statistic (percent)": 
                case "[avg] Kappa Temporal Statistic (percent)": 
                case "[std] Kappa Temporal Statistic (percent)": {
                    kappaTempColumn = i;
                    continue block31;
                }
                case "model cost (RAM-Hours)": 
                case "[std] model cost (RAM-Hours)": {
                    ramColumn = i;
                    continue block31;
                }
                case "evaluation time (cpu seconds)": 
                case "total train time": 
                case "[std] evaluation time (cpu seconds)": {
                    timeColumn = i;
                    continue block31;
                }
                case "model serialized size (bytes)": 
                case "[std] model serialized size (bytes)": {
                    memoryColumn = i;
                    continue block31;
                }
                case "Rel Number of Label Acquisitions": 
                case "[std] Rel Number of Label Acquisitions": {
                    budgetColumn = i;
                    continue block31;
                }
            }
        }
        List<double[]> data = p.getData();
        ALMeasureCollection m = new ALMeasureCollection();
        for (double[] entry : data) {
            m.addValue(0, entry[accuracyColumn]);
            m.addValue(1, entry[kappaColumn]);
            m.addValue(2, entry[kappaTempColumn]);
            m.addValue(3, Math.abs(entry[ramColumn]));
            m.addValue(4, entry[timeColumn]);
            m.addValue(5, entry[memoryColumn] / 1048576.0);
            m.addValue(6, entry[budgetColumn]);
        }
        int processFrequency = (int)data.get(0)[processFrequencyColumn];
        ParsedPreview pp = new ParsedPreview();
        pp.addMeasureCollection(m);
        pp.addProcessFrequency(processFrequency);
        return pp;
    }

    private class ParsedPreview {
        private List<Integer> processFrequencies = new ArrayList<Integer>();
        private List<MeasureCollection> measureCollections = new ArrayList<MeasureCollection>();

        public void add(ParsedPreview other) {
            this.processFrequencies.addAll(other.getProcessFrequencies());
            this.measureCollections.addAll(other.getMeasureCollections());
        }

        public void addProcessFrequency(int pf) {
            this.processFrequencies.add(pf);
        }

        public void addMeasureCollection(MeasureCollection mc) {
            this.measureCollections.add(mc);
        }

        public List<Integer> getProcessFrequencies() {
            return this.processFrequencies;
        }

        public List<MeasureCollection> getMeasureCollections() {
            return this.measureCollections;
        }

        public int[] getProcessFrequenciesArray() {
            int[] processFrequenciesArray = new int[this.processFrequencies.size()];
            int i = 0;
            for (Integer freq : this.processFrequencies) {
                processFrequenciesArray[i] = freq;
                ++i;
            }
            return processFrequenciesArray;
        }

        public MeasureCollection[] getMeasureCollectionsArray() {
            return this.measureCollections.toArray(new MeasureCollection[this.measureCollections.size()]);
        }
    }
}

