/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.clustering;

import com.github.javacliparser.FileOption;
import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.StringOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import moa.core.InputStreamProgressMonitor;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.streams.clustering.ClusteringStream;
import moa.tasks.TaskMonitor;

public class SimpleCSVStream
extends ClusteringStream {
    private static final long serialVersionUID = 1L;
    String defaultfile = "/Users/kokomo40/Dropbox/BT Kim/Datasets/KDDCUP99/KDDCup99.arff";
    public FileOption csvFileOption = new FileOption("csvFile", 'f', "CSV file to load.", this.defaultfile, "csv", false);
    public StringOption splitCharOption = new StringOption("splitChar", 's', "Input CSV split character", ",");
    public FlagOption classIndexOption = new FlagOption("classIndex", 'c', "Last attribute is class index.");
    protected Instances dataset;
    protected BufferedReader fileReader;
    protected boolean hitEndOfFile;
    protected InstanceExample lastInstanceRead;
    protected int numInstancesRead;
    protected int numTokens;
    protected int numAttributes;
    protected InputStreamProgressMonitor fileProgressMonitor;

    public SimpleCSVStream() {
        this.numAttsOption = null;
        this.dataset = null;
        this.fileReader = null;
        this.hitEndOfFile = false;
        this.lastInstanceRead = null;
        this.numInstancesRead = 0;
        this.numTokens = 0;
        this.numAttributes = 0;
        this.fileProgressMonitor = null;
    }

    @Override
    public String getPurposeString() {
        return "A stream read from an CSV file.";
    }

    @Override
    public void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.restart();
    }

    @Override
    public InstancesHeader getHeader() {
        return new InstancesHeader(this.dataset);
    }

    @Override
    public long estimatedRemainingInstances() {
        double progressFraction = this.fileProgressMonitor.getProgressFraction();
        if (progressFraction > 0.0 && this.numInstancesRead > 0) {
            return (long)((double)this.numInstancesRead / progressFraction - (double)this.numInstancesRead);
        }
        return -1L;
    }

    @Override
    public boolean hasMoreInstances() {
        return !this.hitEndOfFile;
    }

    @Override
    public InstanceExample nextInstance() {
        InstanceExample prevInstance = this.lastInstanceRead;
        if (prevInstance != null) {
            ++this.numInstancesRead;
        }
        try {
            String line;
            while ((line = this.fileReader.readLine()) != null && ((line = line.trim()).isEmpty() || line.charAt(0) == '%' || line.charAt(0) == '@')) {
            }
            if (line != null) {
                int i;
                StringTokenizer token = new StringTokenizer(line, this.splitCharOption.getValue());
                double[] value = new double[this.numAttributes];
                for (i = 0; i < this.numTokens && token.hasMoreTokens(); ++i) {
                    value[i] = Double.valueOf(token.nextToken());
                }
                if (i < this.numTokens || token.hasMoreTokens()) {
                    throw new RuntimeException("Next Instance has an wrong cardinality!");
                }
                this.lastInstanceRead = new InstanceExample(new DenseInstance(1.0, value));
                this.lastInstanceRead.getData().setDataset(this.dataset);
                this.hitEndOfFile = false;
            } else {
                this.lastInstanceRead = null;
                this.hitEndOfFile = true;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Read next Instance failed.", ioe);
        }
        return prevInstance;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
        try {
            String line;
            if (this.fileReader != null) {
                this.fileReader.close();
            }
            FileInputStream fileStream = new FileInputStream(this.csvFileOption.getFile());
            this.fileProgressMonitor = new InputStreamProgressMonitor(fileStream);
            this.fileReader = new BufferedReader(new InputStreamReader(this.fileProgressMonitor));
            while ((line = this.fileReader.readLine()) != null && ((line = line.trim()).isEmpty() || line.charAt(0) == '%' || line.charAt(0) == '@')) {
            }
            if (line != null) {
                StringTokenizer token = new StringTokenizer(line, this.splitCharOption.getValue());
                this.numTokens = token.countTokens();
                this.numAttributes = this.numTokens - (this.classIndexOption.isSet() ? 1 : 0) + 1;
                ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.numAttributes);
                for (int i = 1; i < this.numAttributes; ++i) {
                    attributes.add(new Attribute("Dim " + i));
                }
                ArrayList<String> classLabels = new ArrayList<String>();
                classLabels.add("0");
                attributes.add(new Attribute("class", classLabels));
                this.dataset = new Instances(this.csvFileOption.getFile().getName(), attributes, 0);
                this.dataset.setClassIndex(this.numAttributes - 1);
                this.numAttsOption = new IntOption("numAtts", 'a', "", this.numAttributes);
                double[] value = new double[this.numAttributes];
                for (int i = 0; i < this.numTokens && token.hasMoreTokens(); ++i) {
                    value[i] = Double.valueOf(token.nextToken());
                }
                this.lastInstanceRead = new InstanceExample(new DenseInstance(1.0, value));
                this.lastInstanceRead.getData().setDataset(this.dataset);
                this.numInstancesRead = 0;
                this.hitEndOfFile = false;
            } else {
                this.lastInstanceRead = null;
                this.numInstancesRead = 0;
                this.hitEndOfFile = true;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("SimpleCSVStream restart failed.", ioe);
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append("SimpleCSVStream: ");
        sb.append(this.csvFileOption.getFile().getName());
        sb.append("\t NumInstancesRead: ");
        sb.append(this.numInstancesRead);
        sb.append("\t HitEndOfFile: ");
        sb.append(this.hitEndOfFile);
    }
}

