/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.functions;

import moa.classifiers.AbstractClassifier;
import moa.core.Measurement;
import moa.options.FloatOption;
import weka.core.Instance;
import weka.core.Utils;

public class Perceptron
extends AbstractClassifier {
    private static final long serialVersionUID = 221L;
    public FloatOption learningRatioOption = new FloatOption("learningRatio", 'l', "Learning ratio", 1.0);
    protected double[][] weightAttribute;
    protected boolean reset;
    protected int numberAttributes;
    protected int numberClasses;
    protected int numberDetections;

    public String getPurposeString() {
        return "Perceptron classifier: Single perceptron classifier.";
    }

    public void resetLearningImpl() {
        this.reset = true;
    }

    public void trainOnInstanceImpl(Instance inst) {
        if (this.reset) {
            this.reset = false;
            this.numberAttributes = inst.numAttributes();
            this.numberClasses = inst.numClasses();
            this.weightAttribute = new double[inst.numClasses()][inst.numAttributes()];
            for (int i = 0; i < inst.numClasses(); ++i) {
                for (int j = 0; j < inst.numAttributes(); ++j) {
                    this.weightAttribute[i][j] = 0.2 * this.classifierRandom.nextDouble() - 0.1;
                }
            }
        }
        double[] preds = new double[inst.numClasses()];
        for (int i = 0; i < inst.numClasses(); ++i) {
            preds[i] = this.prediction(inst, i);
        }
        double learningRatio = this.learningRatioOption.getValue();
        int actualClass = (int)inst.classValue();
        for (int i = 0; i < inst.numClasses(); ++i) {
            double actual = i == actualClass ? 1.0 : 0.0;
            double delta = (actual - preds[i]) * preds[i] * (1.0 - preds[i]);
            for (int j = 0; j < inst.numAttributes() - 1; ++j) {
                double[] dArray = this.weightAttribute[i];
                int n = j;
                dArray[n] = dArray[n] + learningRatio * delta * inst.value(j);
            }
            double[] dArray = this.weightAttribute[i];
            int n = inst.numAttributes() - 1;
            dArray[n] = dArray[n] + learningRatio * delta;
        }
    }

    public void setWeights(double[][] w) {
        this.weightAttribute = w;
    }

    public double[][] getWeights() {
        return this.weightAttribute;
    }

    public int getNumberAttributes() {
        return this.numberAttributes;
    }

    public int getNumberClasses() {
        return this.numberClasses;
    }

    public double prediction(Instance inst, int classVal) {
        double sum = 0.0;
        for (int i = 0; i < inst.numAttributes() - 1; ++i) {
            sum += this.weightAttribute[classVal][i] * inst.value(i);
        }
        return 1.0 / (1.0 + Math.exp(-(sum += this.weightAttribute[classVal][inst.numAttributes() - 1])));
    }

    public double[] getVotesForInstance(Instance inst) {
        double[] votes = new double[inst.numClasses()];
        if (!this.reset) {
            for (int i = 0; i < votes.length; ++i) {
                votes[i] = this.prediction(inst, i);
            }
            try {
                Utils.normalize(votes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return votes;
    }

    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    public void getModelDescription(StringBuilder out, int indent) {
    }

    public boolean isRandomizable() {
        return true;
    }
}

