/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.splitcriteria;

import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;

public class VarianceReductionSplitCriterion
extends AbstractOptionHandler
implements SplitCriterion {
    private static final long serialVersionUID = 1L;

    public double getMeritOfSplit(double[] preSplitDist, double[][] postSplitDists) {
        double Ni;
        int i;
        double SDR = 0.0;
        double N = preSplitDist[0];
        int count = 0;
        for (i = 0; i < postSplitDists.length; ++i) {
            Ni = postSplitDists[i][0];
            if (!(Ni >= 5.0)) continue;
            ++count;
        }
        if (count == postSplitDists.length) {
            SDR = VarianceReductionSplitCriterion.computeSD(preSplitDist);
            for (i = 0; i < postSplitDists.length; ++i) {
                Ni = postSplitDists[i][0];
                SDR -= Ni / N * VarianceReductionSplitCriterion.computeSD(postSplitDists[i]);
            }
        }
        return SDR;
    }

    public double getRangeOfMerit(double[] preSplitDist) {
        return 1.0;
    }

    public static double computeSD(double[] dist) {
        int N = (int)dist[0];
        double sum = dist[1];
        double sumSq = dist[2];
        return (sumSq - sum * sum / (double)N) / (double)N;
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

