% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSF_Downsample.R
\name{DSF_Downsample}
\alias{DSF_Downsample}
\title{Downsample a Data Stream}
\usage{
DSF_Downsample(dsd, factor = 1)
}
\arguments{
\item{dsd}{The input stream as an \link{DSD} object.}

\item{factor}{the downsampling factor.}
}
\value{
An object of class \code{DSF_Downsample} (subclass of \link{DSF} and \link{DSD}).
}
\description{
Creates a new stream that reduces the frequency of a given stream by a given factor.
}
\examples{
# Simple downsampling example
stream <- DSD_Memory(data.frame(rownum = seq(100))) \%>\% DSF_Downsample(factor = 10)
stream

get_points(stream, n = 2)
get_points(stream, n = 1)
get_points(stream, n = 5)

# DSD_Memory supports getting the remaining points using n = -1
get_points(stream, n = -1)

# Downsample a time series
data(presidents)

stream <- data.frame(
    presidents,
    .time = time(presidents)) \%>\%
  DSD_Memory()

plot(stream, dim = 1, n = 120, method = "ts")

# downsample by taking only every 3rd data point (quarters)
downsampledStream <- stream \%>\% DSF_Downsample(factor = 3)

reset_stream(downsampledStream)
plot(downsampledStream, dim = 1, n = 40, method = "ts")
}
\seealso{
Other DSF: 
\code{\link{DSF_Convolve}()},
\code{\link{DSF_ExponentialMA}()},
\code{\link{DSF_Func}()},
\code{\link{DSF_dplyr}()},
\code{\link{DSF}()}
}
\author{
Michael Hahsler
}
\concept{DSF}
