/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustree;

import java.util.Arrays;
import moa.cluster.CFCluster;
import moa.clusterers.clustree.util.AuxiliaryFunctions;
import weka.core.Instance;

public class ClusKernel
extends CFCluster {
    public static final double EPSILON = 1.0E-8;
    public static final double MIN_VARIANCE = 1.0E-50;
    private double totalN;

    public ClusKernel(double[] point, int dim) {
        super(point, dim);
        this.totalN = 1.0;
    }

    protected ClusKernel(int numberDimensions) {
        super(numberDimensions);
        this.totalN = 0.0;
    }

    protected ClusKernel(ClusKernel other) {
        super(other);
        this.totalN = other.getTotalN();
    }

    public void add(ClusKernel other) {
        super.add(other);
        this.totalN += other.totalN;
    }

    protected void aggregate(ClusKernel other, long timeDifference, double negLambda) {
        this.makeOlder(timeDifference, negLambda);
        this.add(other);
    }

    protected void makeOlder(long timeDifference, double negLambda) {
        if (timeDifference == 0L) {
            return;
        }
        double weightFactor = AuxiliaryFunctions.weight(negLambda, timeDifference);
        this.N *= weightFactor;
        int i = 0;
        while (i < this.LS.length) {
            int n = i;
            this.LS[n] = this.LS[n] * weightFactor;
            int n2 = i++;
            this.SS[n2] = this.SS[n2] * weightFactor;
        }
    }

    public double calcDistance(ClusKernel other) {
        double N1 = this.getWeight();
        double N2 = other.getWeight();
        double[] thisLS = this.LS;
        double[] otherLS = other.LS;
        double res = 0.0;
        for (int i = 0; i < thisLS.length; ++i) {
            double substracted = thisLS[i] / N1 - otherLS[i] / N2;
            res += substracted * substracted;
        }
        return Math.sqrt(res);
    }

    private double getTotalN() {
        return this.totalN;
    }

    protected boolean isEmpty() {
        return this.totalN == 0.0;
    }

    protected void clear() {
        this.totalN = 0.0;
        this.N = 0.0;
        Arrays.fill(this.LS, 0.0);
        Arrays.fill(this.SS, 0.0);
    }

    protected void overwriteOldCluster(ClusKernel other) {
        this.totalN = other.totalN;
        this.N = other.N;
        AuxiliaryFunctions.overwriteDoubleArray(this.LS, other.LS);
        AuxiliaryFunctions.overwriteDoubleArray(this.SS, other.SS);
    }

    public double getWeight() {
        return this.N;
    }

    public CFCluster getCF() {
        return this;
    }

    public double[] getCenter() {
        assert (!this.isEmpty());
        double[] res = new double[this.LS.length];
        double weightedSize = this.getWeight();
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.LS[i] / weightedSize;
        }
        return res;
    }

    public double getInclusionProbability(Instance instance) {
        if (this.N == 1.0) {
            double distance = 0.0;
            for (int i = 0; i < this.LS.length; ++i) {
                double d = this.LS[i] - instance.value(i);
                distance += d * d;
            }
            if ((distance = Math.sqrt(distance)) < 1.0E-8) {
                return 1.0;
            }
            return 0.0;
        }
        double dist = this.calcNormalizedDistance(instance.toDoubleArray());
        if (dist <= this.getRadius()) {
            return 1.0;
        }
        return 0.0;
    }

    public double getRadius() {
        if (this.N == 1.0) {
            return 0.0;
        }
        return this.getDeviation() * this.radiusFactor;
    }

    private double getDeviation() {
        double[] variance = this.getVarianceVector();
        double sumOfDeviation = 0.0;
        for (int i = 0; i < variance.length; ++i) {
            double d = Math.sqrt(variance[i]);
            sumOfDeviation += d;
        }
        return sumOfDeviation / (double)variance.length;
    }

    private double[] getVarianceVector() {
        double[] res = new double[this.LS.length];
        for (int i = 0; i < this.LS.length; ++i) {
            double ls = this.LS[i];
            double ss = this.SS[i];
            double lsDivN = ls / this.getWeight();
            double lsDivNSquared = lsDivN * lsDivN;
            double ssDivN = ss / this.getWeight();
            res[i] = ssDivN - lsDivNSquared;
            if (!(res[i] <= 0.0) || !(res[i] > -1.0E-8)) continue;
            res[i] = 1.0E-50;
        }
        return res;
    }

    private double calcNormalizedDistance(double[] point) {
        double[] variance = this.getVarianceVector();
        double[] center = this.getCenter();
        double res = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double diff = center[i] - point[i];
            res += diff * diff;
        }
        return Math.sqrt(res);
    }
}

