% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms_of_other_authors.R
\name{fpia}
\alias{fpia}
\title{Integer-valued Optimal Univariate Allocation Under Constraints for Stratified
Sampling}
\usage{
fpia(
  n,
  Nh,
  Sh,
  mh = NULL,
  Mh = NULL,
  lambda0 = NULL,
  maxiter = 100,
  tol = .Machine$double.eps * 1000
)
}
\arguments{
\item{n}{target sample size for allocation.}

\item{Nh}{population sizes in strata.}

\item{Sh}{standard deviations for given variable in strata.}

\item{mh}{lower constraints for sample sizes in strata.}

\item{Mh}{upper constraints for sample sizes in strata.}

\item{lambda0}{initial parameter 'lambda' (optional).}

\item{maxiter}{maximal number of iterations for algorithm.}

\item{tol}{the desired accuracy (convergence tolerance).}
}
\value{
A vector of optimal allocation sizes, and number of iterations.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Algorithm for optimal allocation in stratified sampling with lower and upper
constraints based on fixed point iteration.
}
\references{
Münnich, R. T., Sachs, E.W. and Wagner, M. (2012)
Numerical solution of optimal allocation problems in stratified sampling
under box constraints,
\emph{AStA Advances in Statistical Analysis}, 96(3), pp. 435-450.
\doi{10.1007/s10182-011-0176-z}
}
