% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TiTvRatio.R
\name{TiTvRatio}
\alias{TiTvRatio}
\alias{subType}
\alias{isTi}
\alias{isTv}
\title{Transition / Transversion Ratio}
\usage{
TiTvRatio(x)

subType(b1, b2)

isTi(b1, b2)

isTv(b1, b2)
}
\arguments{
\item{x}{a \linkS4class{gtypes} object with aligned sequences or a list of 
aligned DNA sequences.}

\item{b1, b2}{two bases to be compared.}
}
\value{
\code{TiTvRatio}: a vector providing the number of 
  transitions (\code{Ti}), transversions (\code{Tv}), and the 
  transition/transversion ratio (\code{Ti.Tv.ratio}).\cr
\code{subType}: either "ti" for transition, or "tv" for transversion.\cr
\code{isTi} and \code{isTv}: a logical identifying whether 
  the \code{b1} to \code{b2} is a transition or transversion.
}
\description{
Calculate transition/transversion ratio. Test substitution 
  type of two bases.
}
\examples{
data(dolph.seqs)

TiTvRatio(dolph.seqs)

subType("a", "c")

isTi("a", "c")

isTv("a", "c")

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
