% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idRows.R
\name{idRows}
\alias{idRows}
\title{\code{gtypes} ID Rows}
\usage{
idRows(ids, rowNames)
}
\arguments{
\item{ids}{character vector of sample ids.}

\item{rowNames}{a vector of rownames from the \code{@loci} slot of a 
\linkS4class{gtypes} object.}
}
\value{
a vector of row numbers in \code{g@loci} where data for \code{ids}
  are stored.
}
\description{
Return row numbers of \code{@loci} slot for a set of
  sample ids.
}
\examples{
data(msats.g)

ran.ids <- sample(indNames(msats.g), 5)
idRows(ran.ids, rownames(loci(msats.g)))

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

