% Generated by roxygen2 (4.0.2): do not edit by hand
\name{jack.hwe}
\alias{jack.hwe}
\alias{jack.influential}
\alias{plot.jack.influential}
\title{Hardy-Weinberg Equlibrium Jackknife}
\usage{
jack.hwe(g, exclude.num = 1, min.hwe.samples = 5, show.progress = TRUE,
  ...)

jack.influential(jack.result, alpha = 0.05)

\method{plot}{jack.influential}(x, main = "", ...)
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}

\item{exclude.num}{Number of samples to exclude at a time.}

\item{min.hwe.samples}{minimum samples needed to calculate HWE.}

\item{show.progress}{logical. Show progress of jackknife?}

\item{...}{other arguments to be passed to GENEPOP.}

\item{jack.result}{result from run of \code{jack.hwe}.}

\item{alpha}{critical value to determine if exclusion is "influential".}

\item{x}{result from a call to \code{jack.influential}.}

\item{main}{main title for influential sample plots from \code{plot.jack.influential}.}
}
\value{
\code{jack.hwe} returns a list with:
\item{obs}{a named vector of HWE p-values for each locus.}
\item{jack}{a \code{data.frame} of HWE p-values where each row is an exclusion and columns are loci.}
\item{gtypes}{the original \code{gtypes} object.}\cr
\code{jack.influential} returns a list with:
\item{influential}{a \code{data.frame} of influential exclusions.}
\item{allele.freqs}{a \code{data.frame} listing the allele frequencies of influential exclusions.}
\item{odds.ratio}{a \code{matrix} of odds ratios between exclusions (rows) and loci (columns).}
}
\description{
Test influence of samples on Hardy-Weinberg equilibrium via jackknife.
}
\details{
\tabular{ll}{
  \code{jack.hwe} \tab performs a HWE jackknife where all combinations of \code{exclude.num} samples
    are left out and HWE is recalculated.\cr
  \code{jack.influential} \tab calculates odds.ratios between jackknife HWE and observed HWE and identifies
    "influential" samples. Samples are "influential" if the observed HWE p-value is < \code{alpha},
    but is > \code{alpha} when the samples are not present.\cr
  \code{plot.jack.influential} \tab creates a cumulative frequency plot of all odds-ratios from \code{jack.influential}.
    A vertical dashed line marks the smallest influential exclusion.\cr
}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Morin, P.A., R.G. LeDuc, F.I. Archer, K.K. Martien, R. Huebinger, J.W. Bickham,
  and B.L. Taylor. 2009. Significant deviations from Hardy-Weinberg equilibirum caused
  by low levesl of microsatellite genotyping errors. Molecular Ecology Resources 9:498-504.
}

