% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life.Leslie.R
\name{life.Leslie}
\alias{life.Leslie}
\title{Life table for Leslie matrix projections.}
\usage{
life.Leslie(x, nDx, nKx, b0 = c(0.07, 1.7), b1 = c(0.053, 2.8),
  b4 = c(1.522, 1.518), type = "kf", nxx = 0, iwidth = 5,
  width12 = c(1, 4))
}
\arguments{
\item{x}{Age at the beginning of the age classes of the life table.}

\item{nDx}{Number of deaths.}

\item{nKx}{Population size.}

\item{b0}{Coefficients used in Keyfitz-Flieger graduation.}

\item{b1}{First set of coefficients used in Coale-Demeny graduation.}

\item{b4}{Second set of coefficients used in Coale-Demeny graduation.}

\item{type}{Type of life table calculation: "kf", "cd", or "cohort". Default is "kf".}

\item{nxx}{individuals-years lived by those dying in the last (possibly open) age-class. If nxx=0,
the person-years lived by those dying in the interval is the inverse of the central
death rate (corresponding to exponentially distributed failure times).}

\item{iwidth}{Width of the age intervals.}

\item{width12}{Width of the first two age classes.}
}
\value{
A dataframe with nine columns:
\item{x}{Age at the beginning of the interval.}
\item{nax}{Individuals-years lived by those dying in the interval x to x + n.}
\item{nMx}{Period central death rate.}
\item{nqx}{Probability of death between ages x and x + n.}
\item{lx}{Probability of survival to exact age x.}
\item{ndx}{Proportion of deaths occurring between ages x and x + n.}
\item{nLx}{Individuals-years lived in the interval x to x + n.}
\item{Tx}{Individuals-years of life left in the cohort at age x.}
\item{ex}{Life expectancy at age x.}
}
\description{
Constructs either a period or cohort life table from enumerated deaths and mid-interval population estimates.
}
\details{
Constructs a period or cohort life tables from enumerated deaths and mid-interval population sizes
(period) or enumerated deaths and person-years at risk (cohort). x, nDx, and nKx must all the be
same length.

There are currently three options for life table construction. The first two are for the construction
of period life tables. They differ only in the way that person-years lived by those dying in the first
two intervals are handled. For type="kf", the default, the first two values of nax estimated using
Keyfitz and Fleiger’s (1990) regression method. For type="cd", Coale and Demeny’s method
(1983) is used. The Coale-Demeny method uses different coefficients depending on the level of
early mortality. As a result, this method may work better for high-mortality populations.

The third type of life table is a cohort life table, for which the conversion from mortality rates to
probabilities of death is unnecessary, so the nax column of the life table is of limited interest.
}
\note{
Calls functions \code{\link{keyfitz}}, \code{\link{coale}} or \code{\link{cohort}}
}
\references{
Keyfitz, N. (1977). Introduction to the mathematics of populations. 2nd ed. Menlo Park: Addison-Wesley.

Coale, A., Demeny, P. and Vaughn, B. (1983). Regional model life tables and stable populations. 2nd ed. New York: Academic Press.

Keyfitz, N. and Flieger, W. (1990). World population growth and aging: Demographic trends in the late twentieth century. Chicago: University of Chicago Press.

Preston, S.H. Heuveline, P. and Guillot, F. (2001). Demography: Measuring and modeling population processes. Oxford: Blackwell.
}
\seealso{
\code{\link{keyfitz}} \code{\link{coale}} \code{\link{cohort}} \code{\link{Leslie.matrix}}
}
\keyword{leslie-matrix}
\keyword{life-table}
