% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{ld2a}
\alias{ld2a}
\title{List of Data-Frames to a 3D Array}
\usage{
ld2a(
  ld,
  dim.order = c(1, 2, 3),
  dimlab.list = NULL,
  fct = "chr",
  chr = "chr",
  lgl = "int",
  order.lvl = "alphanum",
  decreasing = FALSE,
  na.lvl = FALSE,
  check = TRUE
)
}
\arguments{
\item{ld}{list of data.frames that all have the same dimensions.}

\item{dim.order}{integer vector of length 3 specifying the order of dimensions for
the returned array. The default is \code{c(1,2,3)} which means the rows of the
data.frames in \code{ld} is the first dimension (i.e., rows), the columns of the
data.frames in \code{ld} is the second dimension (i.e., columns), and the list
elements of \code{ld} is the third dimension (i.e., layers).}

\item{dimlab.list}{character vector of length 1 specifying the dimlabel for
the list dimension.}

\item{fct}{character vector of length 1 specifying what factors should be converted
to. There are three options: 1) "chr" for converting to character vectors (i.e.,
factor labels), 2) "int" for converting to integer vectors (i.e., factor codes),
or 3) "fct" for keeping the factor as is without any changes.}

\item{chr}{character vector of length 1 specifying what character vectors should
be converted to. There are three options: 1) "fct" for converting to factors (i.e.,
elements will be factor labels), 2) "int" for converting to integer vectors (i.e.,
factor codes after first converting to a factor), or 3) "chr" for keeping the
character vectors as is without any changes.}

\item{lgl}{character vector of length 1 specifying what logical vectors should
be converted to. There are four options: 1) "fct" for converting to factors (i.e.,
"TRUE" and "FALSE" will be factor labels), 2) "chr" for converting to character
vectors (i.e., elements will be "TRUE" and "FALSE"), 3) "int" for converting to
integer vectors (i.e., TRUE = 1; FALSE = 0), and 4) "lgl" for keeping the logical
vectors as is without any changes.}

\item{order.lvl}{character vector of length 1 specifying how you want to order
the levels of the factor. The options are "alphanum", which sorts the levels
alphanumerically (with NA last); "position", which sorts the levels by the position
the level first appears; "frequency", which sorts the levels by their frequency.
If any frequencies are tied, then the ties are sorted alphanumerically (with NA last).}

\item{decreasing}{logical vector of length 1 specifying whether the ordering of the
levels should be decreasing (TRUE) rather than increasing (FALSE).}

\item{na.lvl}{logical vector of length 1 specifying if NA should be considered a level.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{ld} is a list of data.frames.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
3D array with all the elements from \code{ld} organized into dimensions
specified by \code{dim.order}.
}
\description{
\code{ld2a} converts a list of data.frames to a 3D array. The data.frames must
have the same dimensions.
}
\details{
If the columns of the data.frames in \code{ld} are not all the same typeof, then
the return object is coerced to the most complex type of any data.frame column (e.g.,
character > double > integer > logical). See \code{unlist} for details about
the hierarchy of object types.
}
\examples{
ld <- list("first" = BOD, "second" = BOD*2, "third" = BOD*3)
ld2a(ld)
ld <- list("cars" = cars, "mtcars" = mtcars)
try_expr(ld2a(ld)) # error
}
