% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{is.whole}
\alias{is.whole}
\title{Test for Whole Numbers}
\usage{
is.whole(x, tol = .Machine[["double.eps"]])
}
\arguments{
\item{x}{numeric vector.}

\item{tol}{tolerance allowed for double floating point numbers. This is always
a positive number. The default is based on the numerical characteristics of
the machine that R is running on. See \code{.Machine}.}
}
\value{
TRUE for every element of `x` that is a whole number and FALSE otherwise.
The structure is a logical vector with length = length(`x`) and names = names(`x`).
}
\description{
\code{is.whole} returns whether elements of a numeric vector are whole numbers.
}
\examples{
v <- c(1.0, 1L, 1.1)
is.whole(v)
}
