% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_time-dependent.R
\name{spm_time_dep}
\alias{spm_time_dep}
\title{A function for the model with time-dependent model parameters.}
\usage{
spm_time_dep(
  x,
  start = list(a = -0.05, f1 = 80, Q = 2e-08, f = 80, b = 5, mu0 = 0.001),
  frm = list(at = "a", f1t = "f1", Qt = "Q", ft = "f", bt = "b", mu0t = "mu0"),
  stopifbound = FALSE,
  lb = NULL,
  ub = NULL,
  verbose = FALSE,
  opts = list(algorithm = "NLOPT_LN_NELDERMEAD", maxeval = 100, ftol_rel = 1e-08),
  lrtest = FALSE
)
}
\arguments{
\item{x}{Input data table.}

\item{start}{A list of starting parameters, default: 
\code{start=list(a=-0.5, f1=80, Q=2e-8, f=80, b=5, mu0=1e-5)}.}

\item{frm}{A list of formulas that define age (time) - dependency. 
Default: \code{frm=list(at="a", f1t="f1", Qt="Q", ft="f", bt="b", 
mu0t="mu0")}.}

\item{stopifbound}{Estimation stops if at least one parameter 
achieves lower or upper boundaries. Default: \code{FALSE}.}

\item{lb}{Lower bound of parameters under estimation.}

\item{ub}{Upper bound of parameters under estimation.}

\item{verbose}{Turns on verbosing output.}

\item{opts}{A list of options for \code{nloptr}.
Default value: \code{opt=list(algorithm="NLOPT_LN_NELDERMEAD", 
maxeval=100, ftol_rel=1e-8)}.}

\item{lrtest}{Indicates should Likelihood-Ratio test be performed.
Possible values: \code{TRUE}, \code{H01}, \code{H02}, \code{H03},
\code{H04}, \code{H05} (see package Vignette for details)
Default value: \code{FALSE}.
Please see \code{nloptr} documentation for more information.}
}
\value{
A set of estimates of \code{a}, \code{f1}, \code{Q}, 
\code{f}, \code{b}, \code{mu0}.

status Optimization status (see documentation for nloptr package).

LogLik A logarithm likelihood.

objective A value of objective function (given by nloptr).

message A message given by \code{nloptr} optimization function 
(see documentation for nloptr package).
}
\description{
A function for the model with time-dependent model parameters.
}
\examples{
library(stpm)
set.seed(123)
#Data preparation:
n <- 5
data <- simdata_time_dep(N=n)
# Estimation:
opt.par <- spm_time_dep(data)
opt.par
}
\references{
Yashin, A. et al (2007), Health decline, 
aging and mortality: how are they related? 
Biogerontology, 8(3), 291-302.<DOI:10.1007/s10522-006-9073-3>.
}
