% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toptail.R
\name{toptail_buff}
\alias{toptail_buff}
\title{Clip the beginning and ends of \code{sf} LINESTRING objects}
\usage{
toptail_buff(l, buff, ...)
}
\arguments{
\item{l}{An \code{sf} object representing lines}

\item{buff}{An \code{sf} object with POLYGON geometry to buffer the linestring.}

\item{...}{Arguments passed to \code{sf::st_buffer()}}
}
\description{
Takes lines and removes the start and end point, to a distance determined
by the nearest \code{buff} polygon border.
}
\examples{
l <- routes_fast_sf
buff <- zones_sf
r_toptail <- toptail_buff(l, buff)
nrow(l)
nrow(r_toptail)
plot(zones_sf$geometry)
plot(l$geometry, add = TRUE)
plot(r_toptail$geometry, lwd = 5, add = TRUE)
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_midpoint}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()}
}
\concept{lines}
