% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toptail.R
\name{geo_toptail}
\alias{geo_toptail}
\alias{toptail}
\title{Clip the first and last n metres of SpatialLines}
\usage{
geo_toptail(l, toptail_dist, ...)
}
\arguments{
\item{l}{An \code{sf} object representing lines}

\item{toptail_dist}{The distance (in metres) to top and tail the line by.
Can either be a single value or a vector of the same length as the
SpatialLines object.}

\item{...}{Arguments passed to \code{sf::st_buffer()}}
}
\description{
Takes lines and removes the start and end point, to a distance determined
by the user.
}
\details{
Note: see the function
\href{https://github.com/ropensci/stplanr/blob/v1.0.0/R/toptail.R}{\code{toptailgs()}}
in {stplanr} v0.8.5 for an implementation that uses the geosphere
package.
}
\examples{
lib_versions <- sf::sf_extSoftVersion()
lib_versions
# dont test due to issues with sp classes on some set-ups
if (lib_versions[3] >= "6.3.1") {
  l <- routes_fast_sf[2:4, ]
  l_top_tail <- geo_toptail(l, 300)
  l_top_tail
  plot(sf::st_geometry(l_top_tail))
  plot(sf::st_geometry(geo_toptail(l, 600)), lwd = 9, add = TRUE)
}
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_midpoint}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()}
}
\concept{lines}
