% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_code.R
\name{geo_code}
\alias{geo_code}
\title{Convert text strings into points on the map}
\usage{
geo_code(address, base_url = "http://maps.google.com/maps/api/geocode/json",
  return_all = FALSE)
}
\arguments{
\item{address}{Text string representing the address you want to geocode}

\item{base_url}{The base url to query}

\item{return_all}{Should the request return all information returned by Google Maps?
The default is `FALSE`: to return only two numbers: the longitude and latitude, in that order}
}
\description{
Generate a lat/long pair from data using Google's geolocation API.
}
\examples{
address = "LS7 3HB"
geo_code(address = address)
geo_code(address = address, return_all = TRUE)
}
