% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/willoughby2006eqs.R
\name{will3_right}
\alias{will3_right}
\title{Calculate right-hand side of Willoughby Eqn. 3}
\usage{
will3_right(n, A, X1, Rmax)
}
\arguments{
\item{n}{A numeric vector of one of the parameters of the Willoughby model.}

\item{A}{A numeric vector of one of the parameters of the Willoughby model.}

\item{X1}{A numeric vector of one of the parameters of the Willoughby model.}

\item{Rmax}{A numeric vector giving the radius to maximum winds (in kilometers)
for the tropical storm.}
}
\value{
A numeric vector with the value for the right-hand side of Eqn. 3 in
   Willoughby et al. 2006, using the dual exponential version of that
   equation.
}
\description{
Calculates the right hand side of the version of Eqn. 3 in Willoughby et al.
(2006) with the dual exponential profile.
}
\references{
Willoughby HE, Darling RWR, and Rahn ME. 2006. Parametric representation
of the primary hurricane vortex. Part II: A new family of sectionally
continuous profiles. Monthly Weather Review 134(4):1102-1120.
}

