% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simtrials.surv.R
\name{simtrials.surv}
\alias{simtrials.surv}
\title{Simulate trials with safety monitoring by survival data stopping rules}
\usage{
simtrials.surv(rule, p, MC, A, s = 1)
}
\arguments{
\item{rule}{A \code{rule.surv} object with the safety stopping rule for evaluation}

\item{p}{The probability of a toxicity occurring in \code{tau} units of time
under the null hypothesis}

\item{MC}{Number of Monte Carlo replicated datasets to simulate}

\item{A}{Length of accrual period}

\item{s}{Shape parameter for the Weibull distribution; default value is 1
(exponential distribution)}
}
\value{
A matrix with \code{MC} rows and 14 columns, one row per simulated
        trial. Columns include the stopping rule type and design parameters,
        the numbers of events and enrolled patients, the total follow-up time
        in the cohort, the calendar time when the study ends, the reject/no reject
        decision, and the last stage of monitoring reached when the study ends.
}
\description{
Internal workhorse function used to simulate trials with safety monitoring by
survival data stopping rules. The provided stopping \code{rule} is used for
monitoring of \code{MC} simulated trials. For each trial, a random sample is
generated from a Weibull distribution with shape parameter \code{s} to attain
a toxicity rate of \code{p}. Enrollment times are simulated over an accrual
period of duration \code{A} under a uniform (0,\code{A}) distribution.
}
\examples{
set.seed(13)
wt_rule = calc.rule.surv(n=46,p0=0.15,alpha=0.10,type="WT",tau=100,param=0.25)
sims = simtrials.surv(rule=wt_rule,p=0.15,MC=1000,A=1095)
c(mean(sims$stopped),mean(sims$n.Toxicity),mean(sims$n.Enrolled),mean(sims$Calendar.Time))
sims = simtrials.surv(rule=wt_rule,p=0.35,MC=1000,A=1095)
c(mean(sims$stopped),mean(sims$n.Toxicity),mean(sims$n.Enrolled),mean(sims$Calendar.Time))

gp_rule = calc.rule.surv(n=46,p0=0.15,alpha=0.10,type="GP",tau=100,param=11.5*c(-log(1-0.15),100))
sims = simtrials.surv(rule=gp_rule,p=0.15,MC=1000,A=1095)
c(mean(sims$stopped),mean(sims$n.Toxicity),mean(sims$n.Enrolled),mean(sims$Calendar.Time))
sims = simtrials.surv(rule=gp_rule,p=0.35,MC=1000,A=1095)
c(mean(sims$stopped),mean(sims$n.Toxicity),mean(sims$n.Enrolled),mean(sims$Calendar.Time))

}
