% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.rule.surv.R
\name{lines.rule.surv}
\alias{lines.rule.surv}
\title{Add Stopping Rule Curve to Current Plot (Survival Data)}
\usage{
\method{lines}{rule.surv}(x, ...)
}
\arguments{
\item{x}{A 'rule.surv' object calculated by \code{calc.rule.surv()} function}

\item{...}{Other options to be passed to generic \code{lines()} function}
}
\value{
No return value, function solely modifies current plot
}
\description{
Add a survival stopping rule graphically as a curve on current plot for time-to-event data
}
\examples{
pocock.rule <- calc.rule.surv(n = 30, tau = 100, p0 = 0.1, type = "Pocock", alpha = 0.05)
OBF.rule <- calc.rule.surv(n = 30, tau = 100, p0 = 0.1, type = "OBF", alpha = 0.05)
plot(pocock.rule)
lines(OBF.rule, col = "blue")

}
