% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.localdiag.R
\name{plot.localdiag}
\alias{plot.localdiag}
\title{Plot of the local diagnostics' result on a spatio-temporal point process model}
\usage{
\method{plot}{localdiag}(x, marg = TRUE, col = "grey", col2 = "red", cols = "lightgrey", ...)
}
\arguments{
\item{x}{A \code{localdiag} object}

\item{marg}{Default to \code{TRUE}. If \code{marg = F}, only the
spatio-temporal point pattern is plotted}

\item{col}{Color of the outlying points}

\item{col2}{Color of the network (if applicable)}

\item{cols}{Color of the non-outlying points}

\item{...}{additional unused argument}
}
\description{
This function plots the result of the local diagnostics performed with
\link{localdiag} on either a \code{stp} or \code{stlp} object.
 It highlights the  points of the analysed spatio-temporal point pattern \code{X}
 which are identified as outlying by the
 previously performed local diagnostics; the remaining points of \code{X}
 are also represented.

 It also shows the underlying linear network, if the local diagnostics has been applied
 to point patterns occurring on the same linear network, that is, if \link{localdiag}
 has been applied to a \code{stlp} object.
}
\examples{

\dontrun{

inh <- rstpp(lambda = function(x, y, t, a) {exp(a[1] + a[2]*x)}, 
             par = c(.3, 6), seed = 2)

mod1 <- stppm(inh, formula = ~ 1)

resmod1 <- localdiag(inh, mod1$l, p = .9)

plot(resmod1)
plot(resmod1, marg = FALSE)

}


}
\references{
Adelfio, G., Siino, M., Mateu, J., and Rodríguez-Cortés, F. J. (2020). Some properties of local weighted second-order statistics for spatio-temporal point processes. Stochastic Environmental Research and Risk Assessment, 34(1), 149-168.

D’Angelo, N., Adelfio, G.  and Mateu, J. (2022) Local inhomogeneous second-order characteristics for spatio-temporal point processes on linear networks. Stat Papers. https://doi.org/10.1007/s00362-022-01338-4
}
\seealso{
\link{infl}, \link{print.localdiag}, \link{summary.localdiag}
}
\author{
Nicoletta D'Angelo and Giada Adelfio
}
