% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{GlobalModelConfig}
\alias{GlobalModelConfig}
\title{Object used to get / set global parameters and other global model
configuration options in the "low-level" stochtree interface}
\value{
Global error variance parameter
}
\description{
The "low-level" stochtree interface enables a high degreee of sampler
customization, in which users employ R wrappers around C++ objects
like ForestDataset, Outcome, CppRng, and ForestModel to run the
Gibbs sampler of a BART model with custom modifications.
GlobalModelConfig allows users to specify / query the global parameters
of a model they wish to run.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{global_error_variance}}{Global error variance parameter
Create a new GlobalModelConfig object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GlobalModelConfig-new}{\code{GlobalModelConfig$new()}}
\item \href{#method-GlobalModelConfig-update_global_error_variance}{\code{GlobalModelConfig$update_global_error_variance()}}
\item \href{#method-GlobalModelConfig-get_global_error_variance}{\code{GlobalModelConfig$get_global_error_variance()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GlobalModelConfig-new"></a>}}
\if{latex}{\out{\hypertarget{method-GlobalModelConfig-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GlobalModelConfig$new(global_error_variance = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{global_error_variance}}{Global error variance parameter (default: \code{1.0})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new GlobalModelConfig object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GlobalModelConfig-update_global_error_variance"></a>}}
\if{latex}{\out{\hypertarget{method-GlobalModelConfig-update_global_error_variance}{}}}
\subsection{Method \code{update_global_error_variance()}}{
Update global error variance parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GlobalModelConfig$update_global_error_variance(global_error_variance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{global_error_variance}}{Global error variance parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GlobalModelConfig-get_global_error_variance"></a>}}
\if{latex}{\out{\hypertarget{method-GlobalModelConfig-get_global_error_variance}{}}}
\subsection{Method \code{get_global_error_variance()}}{
Query global error variance parameter for this GlobalModelConfig object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GlobalModelConfig$get_global_error_variance()}\if{html}{\out{</div>}}
}

}
}
