% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stocc-package.R
\docType{data}
\name{habData}
\alias{habData}
\title{A simulated data set of environmental covariates}
\format{A data frame with 1600 observations on the following 5 variables.
\describe{ \item{site}{Site labels}
\item{x}{Longitude
coordinate} \item{y}{Latitude coordinate} \item{habCov1}{a
factor with levels \code{1} \code{2} \code{3}} \item{habCov2}{a numeric
vector} }}
\description{
This data represents a simulated study area. The study area is a 40 x 40
grid of pixels. There are two variables, a factor variable (e.g., a habitat
layer), as well as, a continuous covariate.
}
\examples{
data(habData)
image(x=seq(0.5,39.5,1), y=seq(0.5,39.5,1),
	z=t(matrix(as.numeric(habData$habCov1),40)), main="habData: Factor environmental covariate",
	xlab="x", ylab="y", col=rainbow(3))


dev.new()
image(x=seq(0.5,39.5,1), y=seq(0.5,39.5,1),
	z=t(matrix(habData$habCov2,40)), main="habData: Continuous environmental covariate",
	xlab="x", ylab="y", col=terrain.colors(50))
}
\keyword{datasets}

