% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_story.r
\docType{class}
\name{story}
\alias{story}
\title{Story objects}
\description{
The \pkg{stoRy} package uses the \code{story} object to store
story themes together with other metadata.
}
\section{Fields}{


Each story object has the following ten fields
\describe{
\item{story_id}{A story ID. See examples.}
\item{title}{A string giving the story title.}
\item{writer}{A string giving the story writer.}
\item{director}{A string giving the story director.}
\item{air_date}{A string giving the story original air date in the for YYYY-MM-DD}
\item{summary}{A string giving a summary of the story.}
\item{characters}{A list of story characters. The list has three fields: \code{ObjectCharacters},
\code{MajorCharacters}, and \code{MinorCharacters}. Each list entry should be a ", " separated string
of character names.}
\item{themes}{A data frame of story themes with associated metadata.}
\item{settings}{A data frame of story settings with associated metadata.}
\item{keywords}{A data frame of story keywords with associated metadata.}}
}

\examples{
########################################################################
# Create a story object for the Star Trek The Original Series episode  #
# tos1x19 "The Arena" and manipulate it in various ways                #
########################################################################
story_id <- "tos1x19"
mystory <- story$new(story_id)
print(mystory)

########################################################################
# Add "neo-luddist utopia" as a central theme                          #
########################################################################
mystory$add_theme(theme = "neo-luddist utopia", level = "central")

########################################################################
# Remove "neo-luddist utopia" as a central theme                       #
########################################################################
mystory$remove_theme(theme = "neo-luddist utopia")

########################################################################
# Add "mountain" as a setting                                          #
########################################################################
mystory$add_setting(setting = "mountain")

########################################################################
# Add a new keyword                                                    #
######################################################################## 
mystory$add_keyword(keyword = "Captain Kirk is climbing a mountain")
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{story$new()}}
\item \href{#method-add_theme}{\code{story$add_theme()}}
\item \href{#method-remove_theme}{\code{story$remove_theme()}}
\item \href{#method-add_setting}{\code{story$add_setting()}}
\item \href{#method-remove_setting}{\code{story$remove_setting()}}
\item \href{#method-add_keyword}{\code{story$add_keyword()}}
\item \href{#method-remove_keyword}{\code{story$remove_keyword()}}
\item \href{#method-print}{\code{story$print()}}
\item \href{#method-clone}{\code{story$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{story$new(
  story_id,
  title,
  writer,
  director,
  air_date,
  summary,
  characters,
  themes,
  settings,
  keywords
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_theme"></a>}}
\if{latex}{\out{\hypertarget{method-add_theme}{}}}
\subsection{Method \code{add_theme()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{story$add_theme(
  theme,
  level,
  comment,
  related_cahracters,
  character_class,
  related_aliens,
  related_things
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_theme"></a>}}
\if{latex}{\out{\hypertarget{method-remove_theme}{}}}
\subsection{Method \code{remove_theme()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{story$remove_theme(theme)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_setting"></a>}}
\if{latex}{\out{\hypertarget{method-add_setting}{}}}
\subsection{Method \code{add_setting()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{story$add_setting(setting, capacity)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_setting"></a>}}
\if{latex}{\out{\hypertarget{method-remove_setting}{}}}
\subsection{Method \code{remove_setting()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{story$remove_setting(setting)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_keyword"></a>}}
\if{latex}{\out{\hypertarget{method-add_keyword}{}}}
\subsection{Method \code{add_keyword()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{story$add_keyword(keyword, comment, timing, parent_keyword)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_keyword"></a>}}
\if{latex}{\out{\hypertarget{method-remove_keyword}{}}}
\subsection{Method \code{remove_keyword()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{story$remove_keyword(keyword)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{story$print(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{story$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
