% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\name{docker_types}
\alias{docker_types}
\title{Constructors for complex types}
\description{
Methods for building complex docker types.  This is most objects
more complicated than R's atomic types.  Most functions will
indicate if they require one of these objects in their help.  None
of these functions do anything interesting in their own regard -
they just validate inputs.
}
\details{
The functions here will all depend on the API versions - some of
the most fluid parts of the docker API are the different options
that are supported via things like \code{host_config}.

These functions are needed because \code{stevedore} aims to be a
fairly direct wrapping around the docker API.  For most of the
single host methods the types here are not really used (with the
notable exception of \code{host_config} which is used by
\code{$container$create} and \code{$container$update}).  But for
the swarm endpoints the function definitions would be impossibly
complex if we did not reflect the types.  So rather than one
function call with a hundred arguments, we can build up the
required types.

\Sexpr[results=rd,stage=render]{stevedore:::generate_help("types")}
}
