#' @importFrom tibble tibble
NULL

#' U.S. Inbound/Outbound Migration Data, 1990-2017
#'
#' This data set contains counts/estimates for the number of inbound migrants
#'  in the U.S as well as outbound migrants of American origin to other countries
#'  from 1990 to 2017.
#'
#' @format A data frame with 3535 observations on the following 5 variables.
#' \describe{
#' \item{\code{year}}{a numeric vector for 1990, 1995, 2000, 2005, 2010, 2015, 2017}
#' \item{\code{country}}{a character vector/constant for the United States}
#' \item{\code{category}}{a character vector for whether the \code{count} is inbound to the U.S. from the \code{area} variable or outbound (i.e. American expats) to the  \code{area}  variable in a given year.}
#' \item{\code{area}}{a character vector for the area of origin (if \code{category} == "Inbound") or destination for American migrants (if \code{category} == "Outbound")}
#' \item{\code{count}}{a numeric vector for the count of inbound/outbound migrants}
#' }
#'
#' @details "Cote d'Ivoire", "Curacao", and "Reunion" originally had UTF-8
#' characters, which were removed for maximal compliance with CRAN. CRAN
#' raises a note for every non-ASCII character it sees.
#'
#' @source United Nations Population Division (DESA)
#'
"usa_migration"
