% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_lgcp.r
\name{sim_lgcp}
\alias{sim_lgcp}
\title{Simulate a log-Gaussian Cox process (LGCP)}
\usage{
sim_lgcp(parameters, sf, smesh, tmesh, covariates, all = FALSE)
}
\arguments{
\item{parameters}{A named list of parameter starting values:
\itemize{
\item \code{beta}, a vector of fixed effects coefficients to be estimated, \eqn{\beta}
(same length as \code{ncol(covariates)} + 1 );
\item  \code{log_tau}, the \eqn{\textrm{log}(\tau)} parameter for the GMRF;
\item \code{log_kappa}, \eqn{\textrm{log}(\kappa)} parameter for the GMRF;
\item \code{atanh_rho}, optional, \eqn{\textrm{arctan}(\rho)} AR1 temporal parameter.
}
Default values are used if none are provided. NOTE: these may not always be appropriate.}

\item{sf}{An \code{sf} of type \code{POLYGON} specifying the spatial region
of the domain.}

\item{smesh}{A Delaunay triangulation of the spatial domain returned by \code{INLA::inla.mesh.2d()}.}

\item{tmesh}{Optional, a temporal mesh returned by \code{INLA::inla.mesh.1d()}.}

\item{covariates}{Optional, a \code{matrix} of covariates at each
\code{smesh} and \code{tmesh} node combination.}

\item{all}{Logical, if \code{TRUE} then all model components are returned.}
}
\value{
A named list. If \code{all = FALSE} then only the simulated values of
the GMRF at each mesh node are returned, \code{x}, alongside the number of
events, \code{y}, simulated at each node.
}
\description{
Simulate a realisation of a log-Gaussian Cox process (LGCP) using the
\code{TMB} \code{C++} template. If \code{rho} is supplied in \code{parameters}
as well as \code{tmesh} then spatiotemporal (AR(1)) data will be simulated.
}
\examples{
if(requireNamespace("INLA")){
if(require("sf")) {
data(xyt, package = "stelfi")
domain <- sf::st_as_sf(xyt$window)
bnd <- INLA::inla.mesh.segment(as.matrix(sf::st_coordinates(domain)[, 1:2]))
smesh <- INLA::inla.mesh.2d(boundary = bnd,
max.edge = 0.75, cutoff = 0.3)
parameters <- c(beta = 1, log_tau = log(1), log_kappa = log(1))
sim <- sim_lgcp(parameters = parameters, sf = domain, smesh = smesh)
## spatiotemporal
ndays <- 2
w0 <- 2
tmesh <- INLA::inla.mesh.1d(seq(0, ndays, by = w0))
parameters <- c(beta = 1, log_tau = log(1), log_kappa = log(1), atanh_rho = 0.2)
sim <- sim_lgcp(parameters = parameters, sf = domain, smesh = smesh, tmesh = tmesh)
}
}
}
\seealso{
\code{\link{fit_lgcp}}
}
