% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_t_test_expressions.R
\name{expr_t_bayes}
\alias{expr_t_bayes}
\title{Making expression containing Bayesian \emph{t}-test results}
\usage{
expr_t_bayes(data, x, y, bf.prior = 0.707, paired = FALSE, k = 2, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments (currently ignored).}
}
\description{
Making expression containing Bayesian \emph{t}-test results
}
\examples{
\donttest{
# for reproducibility
set.seed(123)

# ------------- between-subjects design --------------------------

statsExpressions::expr_t_bayes(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE
)

# ------------- within-subjects design -----------------------------

statsExpressions::expr_t_bayes(
  data = dplyr::filter(bugs_long, condition \%in\% c("LDLF", "LDHF")),
  x = condition,
  y = desire,
  paired = TRUE
)
}
}
\references{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
