% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_anova_expressions.R
\name{expr_anova_bayes}
\alias{expr_anova_bayes}
\title{Making expression containing Bayesian one-way ANOVA results.}
\usage{
expr_anova_bayes(data, x, y, paired = FALSE, bf.prior = 0.707, k = 2, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{bf.prior}{A numeric value between \code{0.5} and \code{2} (default \code{0.707}), the
prior width to use in calculating Bayes Factors.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\description{
Making expression containing Bayesian one-way ANOVA results.
}
\examples{
\donttest{
set.seed(123)

# between-subjects ---------------------------------------
# with defaults
statsExpressions::expr_anova_bayes(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem
)

# modifying the defaults
statsExpressions::expr_anova_bayes(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  k = 3,
  bf.prior = 0.8
)

# repeated measures ---------------------------------------
statsExpressions::expr_anova_bayes(
  data = WRS2::WineTasting,
  x = Wine,
  y = Taste,
  paired = TRUE,
  k = 4
)
}
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}
}
