% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{power.prop.ps}
\alias{power.prop.ps}
\title{Approximates the power of a paired-samples test of equal porportions for a
planned sample size}
\usage{
power.prop.ps(alpha, n, p1, p2, phi, es)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{n}{planned sample size}

\item{p1}{planning value of proportion for measurement 1}

\item{p2}{planning value of proportion for measurement 2}

\item{phi}{planning value of phi correlation}

\item{es}{planning value of proportion difference}
}
\value{
Returns the approximate power of the test
}
\description{
Computes the approximate power of a test for equal population proportions in
a paired-samples design (the McNemar test). This function requires planning
values for both proportions and a phi coefficient that describes the
correlation between the two dichotomous measurements. The proportion planning
values can set to .5 for a conservatively low power estimate. The planning
value for the proportion difference (effect size) could be set to the
difference of the two proportion planning values or it could be set to a
minimally interesting effect size. Set the phi correlation planning value
to the smallest value within a plausible range for a conservatively low power
estimate.
}
\examples{
power.prop.ps(.05, 45, .5, .5, .4, .2)

# Should return:
#     Power
# 0.6877652


}
